package com.kuaike.common.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.kuaike.common.kafka.msg.content.RcChatroomUpload;
import com.kuaike.common.kafka.msg.content.RcLogUploadReq;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum SkyCommonMsgType {

    NICKNAME_VIOLATION_UPLOAD(100, "群昵称违规上报", RcLogUploadReq.class.getName()),

    WECHAT_CHAT_ROOM_ADDED(101, "新增群上报", RcChatroomUpload.class.getName());

    ;

    private int type;

    private String desc;

    private String contentClass;

    SkyCommonMsgType(int type, String desc, String contentClass) {
        this.type = type;
        this.desc = desc;
        this.contentClass = contentClass;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, SkyCommonMsgType> MAP;

    private static final Set<Integer> typeSet;

    static {
        MAP = ImmutableMap.copyOf(Arrays.stream(SkyCommonMsgType.values())
            .collect(Collectors.toMap(SkyCommonMsgType::getType, Function.identity())));
        typeSet = ImmutableSet
            .copyOf(Arrays.stream(SkyCommonMsgType.values()).map(a -> a.getType()).collect(Collectors.toSet()));
    }

    public static SkyCommonMsgType getMsgType(Integer type) {
        return MAP.get(type);
    }

    public static boolean contains(int type) {
        return typeSet.contains(type);
    }

}
