
package com.kuaike.common.enums;

import com.google.common.collect.ImmutableMap;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum GenderType {

    UNKNOW(0, "未知"), MALE(1, "男性"), FEMALE(2, "女性"), FM(5, "女变男"), MF(6, "男变女"), OTHER(9, "未说明");

    private int gender;

    private String label;

    public static final Map<Integer, GenderType> MAP;

    static {
        MAP = ImmutableMap.copyOf(
                Arrays.stream(GenderType.values()).collect(Collectors.toMap(GenderType::getGender, Function.identity())));
    }

    GenderType(int gender, String label) {
        this.gender = gender;
        this.label = label;
    }

    public int getGender() {

        return gender;
    }

    public void setGender(int gender) {

        this.gender = gender;
    }

    public String getLabel() {

        return label;
    }

    public void setLabel(String label) {

        this.label = label;
    }

}

    