package com.kuaike.common.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 性别
 * 
 * @author shanyu
 *
 */
public enum GenderEnum implements EnumService {

    M(1, "男"), F(2, "女");

    private int value;
    private String desc;

    private final static Map<Integer, GenderEnum> map = Maps.newHashMap();
    static {
        for (GenderEnum sexEnum : GenderEnum.values()) {
            map.put(sexEnum.value, sexEnum);
        }
    }

    private GenderEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public static GenderEnum getByType(Integer type) {
        GenderEnum sex = map.get(type);
        if (sex == null) {
            return M;
        }
        return sex;
    }

}
