package com.kuaike.common.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

import lombok.Data;

@Data
public class WechatMessage implements Serializable {

    private static final long serialVersionUID = 1L;

    private String requestId;

    private Long id;

    /**
     * 微信号
     */
    private String wechatId;

    /**
     * 昵称
     */
    private String nickName;

    /**
     * 设备id
     */
    private String deviceId;

    /**
     * 是否是自己发送的消息
     */
    private Boolean isSend;

    /**
     * 消息体类型:1.文字，3.图片，34.语音消息，（红包……）
     */
    private Integer type;

    /**
     * 联系人/群,联系人对应微信号,群对应群号@chatroom 
     */
    private String talkerId;

    /**
     * 聊天人的昵称
     */
    private String talkerNickName;

    /**
     * 聊天人的性别
     */
    private Integer talkerSex;

    /**
     * 联系人类型，1:联系人，2:群
     */
    private Integer talkerType;

    /**
     * 群发言人微信号
     */
    private String chatroomTalkerId;

    /**
     * msgSvrId,微信返回消息id，发送的消息没有
     */
    private String msgSvrId;

    private Long createBy;

    private Date createTime;

    private Long updateBy;

    private Date updateTime;

    private Boolean isDeleted;

    /**
     * 消息体
     */
    private String message;

    private Map _jsonMessage;

    private String lvbuffer;
    
    private String token;

    private String imgPath;

    private String transcodeFileUrl;

    private Integer duration;

    private String fileUrl;

    /**
     * 邀请入群的链接
     * 
     * 这个字段是从appmsg的xml中解析出来的。
     */
    private String decodeUrl;

    private String ticket;
    /**
     *  如果为 true 状态，就是导入的数据
     */
    private Boolean isImport;
    /**
     * 是否是添加好友打招呼消息
     */
    private Boolean isAddFriendApply;
}
