/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.text;

import java.util.Stack;
import org.beetl.core.exception.HTMLTagParserException;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.text.Fragment;
import org.beetl.core.text.HTMLTagContentParser;
import org.beetl.core.text.ScriptFragment;
import org.beetl.core.text.Source;

public class HtmlTagEndFragment
extends ScriptFragment {
    HTMLTagContentParser html = null;
    boolean appendCr = false;

    public HtmlTagEndFragment(Source source) {
        super(source);
    }

    @Override
    public StringBuilder getScript() {
        String tagName = null;
        Stack<String> htmlTagStack = this.source.htmlTagConfig.htmlTagStack;
        try {
            tagName = this.html.getTagName();
            if (htmlTagStack.empty()) {
                throw new RuntimeException("\u89e3\u6790html tag\u51fa\u9519");
            }
            String lastTag = htmlTagStack.peek();
            if (!tagName.equals(lastTag)) {
                throw new RuntimeException("\u89e3\u6790html tag\u51fa\u9519,\u671f\u671b\u5339\u914d\u6807\u7b7e" + lastTag);
            }
            htmlTagStack.pop();
            this.script.append("}");
            if (this.appendCr) {
                this.script.append('\n');
            }
            return this.script;
        }
        catch (RuntimeException re) {
            if (tagName == null) {
                tagName = "\u672a\u77e5\u6807\u7b7e";
            }
            GrammarToken token = GrammarToken.createToken(tagName, this.source.curLine + 1);
            HTMLTagParserException ex = new HTMLTagParserException(re.getMessage());
            ex.pushToken(token);
            ex.line = this.source.curLine + 1;
            throw ex;
        }
    }

    @Override
    public Fragment consumeAndReturnNext() {
        String htmlTagBindingAttribute = this.source.htmlTagConfig.htmlTagBindingAttribute;
        this.html = new HTMLTagContentParser(this.source.getParser().attributeNameConvert, this.source.cs, this.source.p, htmlTagBindingAttribute, false);
        this.html.parser();
        this.source.move(this.html.index);
        this.endLine = this.startLine;
        return super.findNext();
    }

    @Override
    public void appendCr() {
        this.appendCr = true;
    }
}

