/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.bspay.sdk.opps.core.sign;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class JsonUtils {
    public static String sort4JsonString(String sourceJson, int maxLayer) throws Exception {
        if (StringUtils.isBlank((CharSequence)sourceJson)) {
            return "";
        }
        Map m = (Map)JSONObject.parseObject((String)sourceJson, TreeMap.class);
        if (maxLayer > 0) {
            for (Map.Entry entry : m.entrySet()) {
                int layer = 0;
                if (!(entry.getValue() instanceof JSONArray)) continue;
                JSONArray array = (JSONArray)entry.getValue();
                JsonUtils.sortJsonArray(array, ++layer, maxLayer);
            }
        }
        return JSON.toJSONString((Object)m);
    }

    private static void sortJsonArray(JSONArray array, int layer, int maxLayer) throws Exception {
        if (layer >= maxLayer) {
            throw new Exception(String.format("json\u5d4c\u5957\u5c42\u6570\u4e0d\u8d85\u8fc7 %d \u5c42.", maxLayer));
        }
        for (int i = 0; i < array.size(); ++i) {
            if (array.get(i) instanceof JSONArray) {
                JsonUtils.sortJsonArray((JSONArray)array.get(i), ++layer, maxLayer);
                continue;
            }
            if (array.get(i) instanceof Comparable) continue;
            Map map = (Map)JSON.parseObject((String)array.get(i).toString(), TreeMap.class);
            array.set(i, (Object)map);
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getValue() instanceof JSONArray)) continue;
                JsonUtils.sortJsonArray((JSONArray)entry.getValue(), ++layer, maxLayer);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String s1 = "{\"array2\": [1,8,\"cherry\",3,\"apple\",0,{\"value\":\"lemon\",\"key\":\"yellow\"}],\"array\": [{\"value\":\"v2\",\"key\":\"k2\"},{\"value\":\"v1\",\"key\":\"k1\"}],\"boolean\": true,\"null\": null,\"number\": 123,\"object\": {\"a\": \"a\",\"c\": \"c\",\"b\": \"b\"},\"string\": \"Hello World\"}";
        String s2 = "{\"array2\": [1,8,\"cherry\",3,\"apple\",0,{\"value\":\"lemon\",\"key\":\"yellow\",\"data\":[{\"name\":\"frank\",\"age\":25,\"colors\":[{\"name\":\"name\",\"color\":\"red\"}]}]}],\"array\": [{\"value\":\"v2\",\"key\":\"k2\"},{\"value\":\"v1\",\"key\":\"k1\"}],\"boolean\": true,\"null\": null,\"number\": 123,\"object\": {\"a\": \"a\",\"c\": \"c\",\"b\": \"b\"},\"string\": \"Hello World\"}";
        String s3 = "{\"array2\": [1,8,3,0],\"boolean\": true,\"null\": null,\"number\": 123,\"object\": {\"a\": \"a\",\"c\": \"c\",\"b\": \"b\"},\"string\": \"Hello World\"}";
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            JsonUtils.sort4JsonString(s2, 4);
            System.out.println(JsonUtils.sort4JsonString(s2, 4));
        }
        long t2 = System.currentTimeMillis();
        System.out.println(t2 - t1);
    }
}

