package com.huifu.bspay.sdk.opps.core.request;

import com.alibaba.fastjson.annotation.JSONField;
import com.huifu.bspay.sdk.opps.core.enums.FunctionCodeEnum;

/**
 * 申请开票
 *
 * @author sdk-generator
 * @Description
 */
public class V2HycInvoiceApplyRequest extends BaseRequest {

    /**
     * 请求流水号
     */
    @JSONField(name = "req_seq_id")
    private String reqSeqId;
    /**
     * 请求日期
     */
    @JSONField(name = "req_date")
    private String reqDate;
    /**
     * 商户汇付id
     */
    @JSONField(name = "huifu_id")
    private String huifuId;
    /**
     * 开票类目
     */
    @JSONField(name = "invoice_category")
    private String invoiceCategory;
    /**
     * 汇付全局流水号集合
     */
    @JSONField(name = "hf_seq_ids")
    private String hfSeqIds;

    @Override
    public FunctionCodeEnum getFunctionCode() {
        return FunctionCodeEnum.V2_HYC_INVOICE_APPLY;
    }

    public V2HycInvoiceApplyRequest() {
    }

    public V2HycInvoiceApplyRequest(String reqSeqId, String reqDate, String huifuId, String invoiceCategory, String hfSeqIds) {
        this.reqSeqId = reqSeqId;
        this.reqDate = reqDate;
        this.huifuId = huifuId;
        this.invoiceCategory = invoiceCategory;
        this.hfSeqIds = hfSeqIds;
    }

    public String getReqSeqId() {
        return reqSeqId;
    }

    public void setReqSeqId(String reqSeqId) {
        this.reqSeqId = reqSeqId;
    }

    public String getReqDate() {
        return reqDate;
    }

    public void setReqDate(String reqDate) {
        this.reqDate = reqDate;
    }

    public String getHuifuId() {
        return huifuId;
    }

    public void setHuifuId(String huifuId) {
        this.huifuId = huifuId;
    }

    public String getInvoiceCategory() {
        return invoiceCategory;
    }

    public void setInvoiceCategory(String invoiceCategory) {
        this.invoiceCategory = invoiceCategory;
    }

    public String getHfSeqIds() {
        return hfSeqIds;
    }

    public void setHfSeqIds(String hfSeqIds) {
        this.hfSeqIds = hfSeqIds;
    }

}
