/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.requestfactory.server;

import com.google.gwt.requestfactory.server.DefaultExceptionHandler;
import com.google.gwt.requestfactory.server.ExceptionHandler;
import com.google.gwt.requestfactory.server.Logging;
import com.google.gwt.requestfactory.server.ServiceLayer;
import com.google.gwt.requestfactory.server.ServiceLayerDecorator;
import com.google.gwt.requestfactory.server.SimpleRequestProcessor;
import com.google.gwt.user.server.rpc.RPCServletUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestFactoryServlet
extends HttpServlet {
    private static final boolean DUMP_PAYLOAD = Boolean.getBoolean("gwt.rpc.dumpPayload");
    private static final String JSON_CHARSET = "UTF-8";
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final Logger log = Logger.getLogger(RequestFactoryServlet.class.getCanonicalName());
    private static final ThreadLocal<HttpServletRequest> perThreadRequest = new ThreadLocal();
    private static final ThreadLocal<HttpServletResponse> perThreadResponse = new ThreadLocal();
    private final SimpleRequestProcessor processor;

    public static HttpServletRequest getThreadLocalRequest() {
        return perThreadRequest.get();
    }

    public static HttpServletResponse getThreadLocalResponse() {
        return perThreadResponse.get();
    }

    public RequestFactoryServlet() {
        this(new DefaultExceptionHandler(), new ServiceLayerDecorator[0]);
    }

    public RequestFactoryServlet(ExceptionHandler exceptionHandler, ServiceLayerDecorator ... serviceDecorators) {
        this.processor = new SimpleRequestProcessor(ServiceLayer.create(serviceDecorators));
        this.processor.setExceptionHandler(exceptionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        perThreadRequest.set(request);
        perThreadResponse.set(response);
        try {
            this.ensureConfig();
            String jsonRequestString = RPCServletUtils.readContent(request, JSON_CONTENT_TYPE, JSON_CHARSET);
            if (DUMP_PAYLOAD) {
                System.out.println(">>> " + jsonRequestString);
            }
            try {
                String payload = this.processor.process(jsonRequestString);
                if (DUMP_PAYLOAD) {
                    System.out.println("<<< " + payload);
                }
                response.setStatus(200);
                response.setContentType("application/json; charset=utf-8");
                PrintWriter writer = response.getWriter();
                writer.print(payload);
                writer.flush();
            }
            catch (RuntimeException e) {
                response.sendError(500);
                log.log(Level.SEVERE, "Unexpected error", e);
            }
        }
        finally {
            perThreadRequest.set(null);
            perThreadResponse.set(null);
        }
    }

    private void ensureConfig() {
        String symbolMapsDirectory = this.getServletConfig().getInitParameter("symbolMapsDirectory");
        if (symbolMapsDirectory != null) {
            Logging.setSymbolMapsDirectory(symbolMapsDirectory);
        }
    }
}

