/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.ApiException;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.FutureCallable;
import com.google.api.gax.grpc.NanoClock;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.CallOptions;
import io.grpc.Status;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.joda.time.Duration;

class RetryingCallable<RequestT, ResponseT>
implements FutureCallable<RequestT, ResponseT> {
    static final Duration DEADLINE_SLEEP_DURATION = Duration.millis((long)1L);
    private final FutureCallable<RequestT, ResponseT> callable;
    private final RetrySettings retryParams;
    private final UnaryCallable.Scheduler executor;
    private final NanoClock clock;

    RetryingCallable(FutureCallable<RequestT, ResponseT> callable, RetrySettings retrySettings, UnaryCallable.Scheduler executor, NanoClock clock) {
        this.callable = (FutureCallable)Preconditions.checkNotNull(callable);
        this.retryParams = (RetrySettings)Preconditions.checkNotNull((Object)retrySettings);
        this.executor = executor;
        this.clock = clock;
    }

    @Override
    public ListenableFuture<ResponseT> futureCall(RequestT request, CallContext context) {
        RetryingResultFuture resultFuture = new RetryingResultFuture();
        context = RetryingCallable.getCallContextWithDeadlineAfter(context, this.retryParams.getTotalTimeout());
        Retryer retryer = new Retryer(request, context, resultFuture, this.retryParams.getInitialRetryDelay(), this.retryParams.getInitialRpcTimeout(), null);
        resultFuture.issueCall(request, context, retryer);
        return resultFuture;
    }

    public String toString() {
        return String.format("retrying(%s)", this.callable);
    }

    private static CallContext getCallContextWithDeadlineAfter(CallContext oldCtx, Duration rpcTimeout) {
        CallOptions oldOpt = oldCtx.getCallOptions();
        CallOptions newOpt = oldOpt.withDeadlineAfter(rpcTimeout.getMillis(), TimeUnit.MILLISECONDS);
        CallContext newCtx = oldCtx.withCallOptions(newOpt);
        if (oldOpt.getDeadlineNanoTime() == null) {
            return newCtx;
        }
        if (oldOpt.getDeadlineNanoTime() < newOpt.getDeadlineNanoTime()) {
            return oldCtx;
        }
        return newCtx;
    }

    private static boolean canRetry(Throwable throwable) {
        if (!(throwable instanceof ApiException)) {
            return false;
        }
        ApiException apiException = (ApiException)throwable;
        return apiException.isRetryable();
    }

    private static boolean isDeadlineExceeded(Throwable throwable) {
        if (!(throwable instanceof ApiException)) {
            return false;
        }
        ApiException apiException = (ApiException)throwable;
        return apiException.getStatusCode() == Status.Code.DEADLINE_EXCEEDED;
    }

    private class RetryingResultFuture
    extends AbstractFuture<ResponseT> {
        private volatile Future<?> activeFuture = null;
        private final Object syncObject = new Object();

        private RetryingResultFuture() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void interruptTask() {
            Object object = this.syncObject;
            synchronized (object) {
                this.activeFuture.cancel(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean set(@Nullable ResponseT value) {
            Object object = this.syncObject;
            synchronized (object) {
                return super.set(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setException(Throwable throwable) {
            Object object = this.syncObject;
            synchronized (object) {
                if (throwable instanceof CancellationException) {
                    super.cancel(false);
                    return true;
                }
                return super.setException(throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleNext(UnaryCallable.Scheduler executor, Runnable retryer, long delay, TimeUnit unit) {
            Object object = this.syncObject;
            synchronized (object) {
                if (!this.isCancelled()) {
                    this.activeFuture = executor.schedule(retryer, delay, TimeUnit.MILLISECONDS);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void issueCall(RequestT request, CallContext deadlineContext, Retryer retryer) {
            Object object = this.syncObject;
            synchronized (object) {
                if (!this.isCancelled()) {
                    ListenableFuture callFuture = RetryingCallable.this.callable.futureCall(request, deadlineContext);
                    Futures.addCallback(callFuture, (FutureCallback)retryer);
                    this.activeFuture = callFuture;
                }
            }
        }
    }

    private class Retryer
    implements Runnable,
    FutureCallback<ResponseT> {
        private final RequestT request;
        private final CallContext context;
        private final RetryingResultFuture resultFuture;
        private final Duration retryDelay;
        private final Duration rpcTimeout;
        private final Throwable savedThrowable;

        private Retryer(RequestT request, CallContext context, RetryingResultFuture resultFuture, Duration retryDelay, Duration rpcTimeout, Throwable savedThrowable) {
            this.request = request;
            this.context = context;
            this.resultFuture = resultFuture;
            this.retryDelay = retryDelay;
            this.rpcTimeout = rpcTimeout;
            this.savedThrowable = savedThrowable;
        }

        @Override
        public void run() {
            if (this.context.getCallOptions().getDeadlineNanoTime() < RetryingCallable.this.clock.nanoTime()) {
                if (this.savedThrowable == null) {
                    this.resultFuture.setException((Throwable)Status.DEADLINE_EXCEEDED.withDescription("Total deadline exceeded without completing any call").asException());
                } else {
                    this.resultFuture.setException(this.savedThrowable);
                }
                return;
            }
            CallContext deadlineContext = RetryingCallable.getCallContextWithDeadlineAfter(this.context, this.rpcTimeout);
            this.resultFuture.issueCall(this.request, deadlineContext, this);
        }

        public void onSuccess(ResponseT r) {
            this.resultFuture.set(r);
        }

        public void onFailure(Throwable throwable) {
            if (!RetryingCallable.canRetry(throwable)) {
                this.resultFuture.setException(throwable);
                return;
            }
            if (RetryingCallable.isDeadlineExceeded(throwable)) {
                Retryer retryer = new Retryer(this.request, this.context, this.resultFuture, this.retryDelay, this.rpcTimeout, throwable);
                this.resultFuture.scheduleNext(RetryingCallable.this.executor, retryer, DEADLINE_SLEEP_DURATION.getMillis(), TimeUnit.MILLISECONDS);
                return;
            }
            long newRetryDelay = (long)((double)this.retryDelay.getMillis() * RetryingCallable.this.retryParams.getRetryDelayMultiplier());
            newRetryDelay = Math.min(newRetryDelay, RetryingCallable.this.retryParams.getMaxRetryDelay().getMillis());
            long newRpcTimeout = (long)((double)this.rpcTimeout.getMillis() * RetryingCallable.this.retryParams.getRpcTimeoutMultiplier());
            newRpcTimeout = Math.min(newRpcTimeout, RetryingCallable.this.retryParams.getMaxRpcTimeout().getMillis());
            long randomRetryDelay = ThreadLocalRandom.current().nextLong(this.retryDelay.getMillis());
            Retryer retryer = new Retryer(this.request, this.context, this.resultFuture, Duration.millis((long)newRetryDelay), Duration.millis((long)newRpcTimeout), throwable);
            this.resultFuture.scheduleNext(RetryingCallable.this.executor, retryer, randomRetryDelay, TimeUnit.MILLISECONDS);
        }
    }
}

