/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.BundlingFuture;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.RequestIssuer;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.common.base.Preconditions;

public final class BundlingContext<RequestT, ResponseT>
implements RequestIssuer<RequestT, ResponseT> {
    private final RequestT request;
    private final CallContext context;
    private final UnaryCallable<RequestT, ResponseT> callable;
    private final BundlingFuture<ResponseT> bundlingFuture;
    private ResponseT responseToSend;
    private Throwable throwableToSend;

    public BundlingContext(RequestT request, CallContext context, UnaryCallable<RequestT, ResponseT> callable, BundlingFuture<ResponseT> bundlingFuture) {
        this.request = request;
        this.context = context;
        this.callable = callable;
        this.bundlingFuture = bundlingFuture;
        this.responseToSend = null;
        this.throwableToSend = null;
    }

    public CallContext getCallContext() {
        return this.context;
    }

    public UnaryCallable<RequestT, ResponseT> getCallable() {
        return this.callable;
    }

    @Override
    public RequestT getRequest() {
        return this.request;
    }

    @Override
    public void setResponse(ResponseT response) {
        Preconditions.checkState((this.throwableToSend == null ? 1 : 0) != 0, (Object)"Cannot set both exception and response");
        this.responseToSend = response;
    }

    @Override
    public void setException(Throwable throwable) {
        Preconditions.checkState((this.throwableToSend == null ? 1 : 0) != 0, (Object)"Cannot set both exception and response");
        this.throwableToSend = throwable;
    }

    public void sendResult() {
        if (this.responseToSend != null) {
            this.bundlingFuture.set(this.responseToSend);
        } else if (this.throwableToSend != null) {
            this.bundlingFuture.setException(this.throwableToSend);
        } else {
            throw new IllegalStateException("Neither response nor exception were set in BundlingContext");
        }
    }
}

