/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.bundling.ThresholdBundleHandle;
import com.google.api.gax.bundling.ThresholdBundlingForwarder;
import com.google.api.gax.grpc.BundlerFactory;
import com.google.api.gax.grpc.BundlingContext;
import com.google.api.gax.grpc.BundlingDescriptor;
import com.google.api.gax.grpc.BundlingFuture;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.FutureCallable;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;

class BundlingCallable<RequestT, ResponseT>
implements FutureCallable<RequestT, ResponseT> {
    private final FutureCallable<RequestT, ResponseT> callable;
    private final BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor;
    private final BundlerFactory<RequestT, ResponseT> bundlerFactory;

    public BundlingCallable(FutureCallable<RequestT, ResponseT> callable, BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor, BundlerFactory<RequestT, ResponseT> bundlerFactory) {
        this.callable = (FutureCallable)Preconditions.checkNotNull(callable);
        this.bundlingDescriptor = (BundlingDescriptor)Preconditions.checkNotNull(bundlingDescriptor);
        this.bundlerFactory = (BundlerFactory)Preconditions.checkNotNull(bundlerFactory);
    }

    @Override
    public ListenableFuture<ResponseT> futureCall(RequestT request, CallContext context) {
        if (this.bundlerFactory.getBundlingSettings().getIsEnabled().booleanValue()) {
            BundlingFuture result = BundlingFuture.create();
            UnaryCallable<RequestT, ResponseT> unaryCallable = UnaryCallable.create(this.callable).bind(context.getChannel());
            BundlingContext<RequestT, ResponseT> bundlableMessage = new BundlingContext<RequestT, ResponseT>(request, context, unaryCallable, result);
            String partitionKey = this.bundlingDescriptor.getBundlePartitionKey(request);
            ThresholdBundlingForwarder<BundlingContext<RequestT, ResponseT>> forwarder = this.bundlerFactory.getForwarder(partitionKey);
            ThresholdBundleHandle bundleHandle = forwarder.addToNextBundle(bundlableMessage);
            result.setBundleHandle(bundleHandle);
            return result;
        }
        return this.callable.futureCall(request, context);
    }
}

