/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.protocol.views;

import com.couchbase.client.protocol.views.AbstractView;
import com.couchbase.client.protocol.views.RowError;
import com.couchbase.client.protocol.views.SpatialView;
import com.couchbase.client.protocol.views.ViewException;
import com.couchbase.client.protocol.views.ViewOperation;
import com.couchbase.client.protocol.views.ViewOperationImpl;
import com.couchbase.client.protocol.views.ViewResponseReduced;
import com.couchbase.client.protocol.views.ViewRow;
import com.couchbase.client.protocol.views.ViewRowReduced;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.logging.Level;
import org.apache.http.HttpRequest;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ReducedOperationImpl
extends ViewOperationImpl {
    public ReducedOperationImpl(HttpRequest r, AbstractView view, ViewOperation.ViewCallback cb) {
        super(r, view, cb);
        if (this.getView() instanceof SpatialView) {
            throw new IllegalArgumentException("Spatial views do not support reduce");
        }
    }

    @Override
    protected ViewResponseReduced parseResult(String json) throws ParseException {
        LinkedList<ViewRow> rows = new LinkedList<ViewRow>();
        LinkedList<RowError> errors = new LinkedList<RowError>();
        if (json != null) {
            try {
                JSONObject elem;
                int i;
                JSONArray ids;
                JSONObject base = new JSONObject(json);
                if (base.has("rows")) {
                    ids = base.getJSONArray("rows");
                    for (i = 0; i < ids.length(); ++i) {
                        elem = ids.getJSONObject(i);
                        String key = elem.getString("key");
                        String value = elem.getString("value");
                        rows.add(new ViewRowReduced(key, value));
                    }
                }
                if (base.has("debug_info")) {
                    LOGGER.log(Level.INFO, "Debugging View {0}: {1}", new Object[]{this.getView().getURI(), json});
                }
                if (base.has("errors")) {
                    ids = base.getJSONArray("errors");
                    for (i = 0; i < ids.length(); ++i) {
                        elem = ids.getJSONObject(i);
                        String from = elem.getString("from");
                        String reason = elem.getString("reason");
                        errors.add(new RowError(from, reason));
                    }
                }
            }
            catch (JSONException e) {
                throw new ParseException("Cannot read json: " + json, 0);
            }
        }
        return new ViewResponseReduced(rows, errors);
    }

    @Override
    protected void parseError(String json, int errorcode) throws ParseException {
        String error = null;
        String reason = null;
        if (json != null) {
            try {
                JSONObject base = new JSONObject(json);
                if (base.has("error") && base.has("reason")) {
                    error = base.getString("error");
                    reason = base.getString("reason");
                }
            }
            catch (JSONException e) {
                error = "HTTP " + Integer.toString(errorcode);
                reason = "No extra information given";
            }
        }
        this.setException(new ViewException(error, reason));
    }
}

