/*
 * Decompiled with CFR 0.152.
 */
package com.chinaums.upp.comn.exception;

import com.chinaums.upp.comn.exception.UppErrorCode;

public class UppException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected String errorMsg;
    protected String errorNum;

    public UppException(Throwable cause) {
        this(UppErrorCode.RSP_OTHER_ERROR_CODE, cause);
    }

    public UppException(UppErrorCode errorCode, String errMsg) {
        super(errMsg);
        this.errorNum = errorCode.getErrNum();
        this.errorMsg = errMsg;
    }

    public UppException(String errNum, String errMsg) {
        super(errMsg);
        this.errorNum = errNum;
        this.errorMsg = errMsg;
    }

    public UppException(UppErrorCode errorCode) {
        super(errorCode.getErrMsg());
        this.errorNum = errorCode.getErrNum();
        this.errorMsg = errorCode.getErrMsg();
    }

    public UppException(String errMsg) {
        super(errMsg);
        this.errorNum = UppErrorCode.RSP_PARAM_ERROR_CODE.getErrNum();
        this.errorMsg = errMsg;
    }

    public UppException(String errMsg, Throwable cause) {
        super(cause);
        this.errorNum = UppErrorCode.RSP_DEALING_ERROR_CODE.getErrNum();
        this.errorMsg = errMsg;
    }

    public UppException(UppErrorCode errorCode, Throwable cause) {
        super(cause);
        this.errorNum = errorCode.getErrNum();
        this.errorMsg = errorCode.getErrMsg();
    }

    public UppException(String errNum, String errMsg, Throwable cause) {
        super(cause);
        this.errorNum = errNum;
        this.errorMsg = errMsg;
    }

    public String getErrorNum() {
        return this.errorNum;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public String getMessage() {
        return this.errorNum + "," + this.errorMsg;
    }
}

