/*
 * Decompiled with CFR 0.152.
 */
package com.gnete.common.rpc.dto;

import com.gnete.common.constant.ResultCode;
import com.gnete.common.rpc.dto.BaseResponse;

public class ResultDTO<T>
extends BaseResponse {
    private static final long serialVersionUID = -4998081848028542822L;
    private T data;

    public ResultDTO() {
    }

    public ResultDTO(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public ResultDTO(String code, String msg, T data) {
        this(code, msg);
        this.data = data;
    }

    public static <T> ResultDTO<T> newSuccess(T data) {
        return ResultDTO.newResult(ResultCode.CODE_00000, data);
    }

    public static <T> ResultDTO<T> newSuccess() {
        return ResultDTO.newResult(ResultCode.CODE_00000, (String)null);
    }

    public boolean isSuccess() {
        return ResultCode.CODE_00000.getCode().equals(this.code);
    }

    public static ResultDTO newSystemException() {
        return ResultDTO.newSystemException(null);
    }

    public static ResultDTO newSystemException(String msg) {
        return ResultDTO.newResult(ResultCode.CODE_10000, msg);
    }

    public static ResultDTO newBizException() {
        return ResultDTO.newBizException(null);
    }

    public static ResultDTO newBizException(String msg) {
        return ResultDTO.newResult(ResultCode.CODE_39999, msg);
    }

    public static ResultDTO newArgumentException() {
        return ResultDTO.newArgumentException(null);
    }

    public static ResultDTO newArgumentException(String msg) {
        return ResultDTO.newResult(ResultCode.CODE_10004, msg);
    }

    public static <T> ResultDTO<T> newResult(ResultCode resultCode) {
        return ResultDTO.newResult(resultCode, (String)null, null);
    }

    public static <T> ResultDTO<T> newResult(ResultCode resultCode, String msg) {
        return ResultDTO.newResult(resultCode, msg, null);
    }

    public static <T> ResultDTO<T> newResult(ResultCode resultCode, T data) {
        return ResultDTO.newResult(resultCode, (String)null, data);
    }

    public static <T> ResultDTO<T> newResult(ResultCode resultCode, String msg, T data) {
        if (resultCode == null) {
            resultCode = ResultCode.CODE_10000;
        }
        if (msg == null || msg == "") {
            msg = resultCode.getMsg();
        }
        return ResultDTO.newResult(resultCode.getCode(), msg, data);
    }

    public static <T> ResultDTO<T> newResult(String code, String msg) {
        return new ResultDTO<Object>(code, msg, null);
    }

    public static <T> ResultDTO<T> newResult(String code, String msg, T data) {
        return new ResultDTO<T>(code, msg, data);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getMsg() {
        return this.msg;
    }

    @Override
    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

