/*
 * Decompiled with CFR 0.152.
 */
package com.belerweb.social.weixin.bean;

import com.belerweb.social.bean.Gender;
import com.belerweb.social.bean.JsonBean;
import com.belerweb.social.bean.Result;
import java.util.Date;
import java.util.List;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends JsonBean {
    private String openId;
    private String unionID;
    private String nickname;
    private Gender gender;
    private String province;
    private String city;
    private String country;
    private List<String> privilege;
    private String language;
    private String headImgUrl;
    private Boolean subscribe;
    private Date subscribeTime;

    public User() {
    }

    private User(JSONObject jsonObject) {
        super(jsonObject);
    }

    public String getOpenId() {
        return this.openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public List<String> getPrivilege() {
        return this.privilege;
    }

    public void setPrivilege(List<String> privilege) {
        this.privilege = privilege;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getHeadImgUrl() {
        return this.headImgUrl;
    }

    public void setHeadImgUrl(String headImgUrl) {
        this.headImgUrl = headImgUrl;
    }

    public Boolean getSubscribe() {
        return this.subscribe;
    }

    public void setSubscribe(Boolean subscribe) {
        this.subscribe = subscribe;
    }

    public Date getSubscribeTime() {
        return this.subscribeTime;
    }

    public void setSubscribeTime(Date subscribeTime) {
        this.subscribeTime = subscribeTime;
    }

    public String getUnionID() {
        return this.unionID;
    }

    public void setUnionID(String unionID) {
        this.unionID = unionID;
    }

    public static User parse(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        User obj = new User(jsonObject);
        obj.openId = Result.toString(jsonObject.get("openid"));
        if (jsonObject.has("unionid")) {
            obj.unionID = Result.toString(jsonObject.get("unionid"));
        }
        obj.nickname = Result.toString(jsonObject.opt("nickname"));
        obj.gender = Gender.parse(Result.parseInteger(jsonObject.opt("sex")));
        obj.province = Result.toString(jsonObject.opt("province"));
        obj.city = Result.toString(jsonObject.opt("city"));
        obj.country = Result.toString(jsonObject.opt("country"));
        obj.language = Result.toString(jsonObject.opt("language"));
        obj.headImgUrl = Result.toString(jsonObject.opt("headimgurl"));
        obj.subscribe = Result.parseBoolean(jsonObject.opt("subscribe"));
        Long subscribeTime = Result.parseLong(jsonObject.opt("subscribe_time"));
        if (subscribeTime != null) {
            obj.subscribeTime = new Date(subscribeTime * 1000L);
        }
        obj.privilege = Result.parse(jsonObject.optJSONArray("privilege"), String.class);
        return obj;
    }
}

