/*
 * Decompiled with CFR 0.152.
 */
package com.belerweb.social.qq.connect.api;

import com.belerweb.social.SDK;
import com.belerweb.social.bean.Error;
import com.belerweb.social.bean.Result;
import com.belerweb.social.exception.SocialException;
import com.belerweb.social.http.Http;
import com.belerweb.social.qq.connect.api.OAuth2;
import com.belerweb.social.qq.connect.api.User;
import com.belerweb.social.qq.connect.bean.NewT;
import com.belerweb.social.qq.connect.bean.TenpayAddress;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QQConnect
extends SDK {
    private String clientId;
    private String clientSecret;
    private String redirectUri;
    private OAuth2 oAuth2;
    private User user;

    public QQConnect(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public QQConnect(String clientId, String clientSecret, String redirectUri) {
        this(clientId, clientSecret);
        this.redirectUri = redirectUri;
    }

    public Result<Error> addIdol(String accessToken, String openId, List<String> name) {
        return this.addIdol(accessToken, openId, name, null);
    }

    public Result<Error> addIdol(String accessToken, String openId, List<String> name, List<String> fopenids) {
        return this.addIdol(accessToken, this.getClientId(), openId, name, fopenids);
    }

    public Result<Error> addIdol(String accessToken, String oauthConsumerKey, String openId, List<String> name, List<String> fopenids) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addParameter(params, "access_token", accessToken);
        this.addParameter(params, "oauth_consumer_key", oauthConsumerKey);
        this.addParameter(params, "openid", openId);
        if (name != null && !name.isEmpty()) {
            this.addParameter(params, "name", StringUtils.join(name, (String)","));
        }
        if (fopenids != null && !fopenids.isEmpty()) {
            this.addParameter(params, "fopenids", StringUtils.join(fopenids, (String)"_"));
        }
        this.addParameter(params, "format", "json");
        return Result.parse(this.post("https://graph.qq.com/relation/add_idol", params), Error.class);
    }

    public Result<Error> delIdol(String accessToken, String openId, String name) {
        return this.delIdol(accessToken, openId, name, null);
    }

    public Result<Error> delIdol(String accessToken, String openId, String name, String fopenid) {
        return this.delIdol(accessToken, this.getClientId(), openId, name, fopenid);
    }

    public Result<Error> delIdol(String accessToken, String oauthConsumerKey, String openId, String name, String fopenid) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addParameter(params, "access_token", accessToken);
        this.addParameter(params, "oauth_consumer_key", oauthConsumerKey);
        this.addParameter(params, "openid", openId);
        this.addNotNullParameter(params, "name", name);
        this.addNotNullParameter(params, "fopenid", fopenid);
        this.addParameter(params, "format", "json");
        return Result.parse(this.post("https://graph.qq.com/relation/del_idol", params), Error.class);
    }

    public Result<Error> addOneBlog(String accessToken, String openId, String title, String content) {
        return this.addOneBlog(accessToken, this.getClientId(), openId, title, content);
    }

    public Result<Error> addOneBlog(String accessToken, String oauthConsumerKey, String openId, String title, String content) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addParameter(params, "access_token", accessToken);
        this.addParameter(params, "oauth_consumer_key", oauthConsumerKey);
        this.addParameter(params, "openid", openId);
        this.addParameter(params, "title", title);
        this.addParameter(params, "content", content);
        this.addParameter(params, "format", "json");
        return Result.parse(this.post("https://graph.qq.com/blog/add_one_blog", params), Error.class);
    }

    public Result<NewT> addT(String accessToken, String openId, String content) {
        return this.addT(accessToken, this.getClientId(), openId, content);
    }

    public Result<NewT> addT(String accessToken, String oauthConsumerKey, String openId, String content) {
        return this.addT(accessToken, oauthConsumerKey, openId, content, null, null, null, true, true);
    }

    public Result<NewT> addT(String accessToken, String oauthConsumerKey, String openId, String content, String clientIp, Double lon, Double lat, Boolean sync, Boolean compatible) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addParameter(params, "access_token", accessToken);
        this.addParameter(params, "oauth_consumer_key", oauthConsumerKey);
        this.addParameter(params, "openid", openId);
        this.addParameter(params, "content", content);
        this.addNotNullParameter(params, "clientip", clientIp);
        this.addNotNullParameter(params, "lon", lon);
        this.addNotNullParameter(params, "lat", lat);
        if (sync != null) {
            this.addParameter(params, "syncflag", sync != false ? "0" : "1");
        }
        if (compatible != null) {
            this.addParameter(params, "compatibleflag", compatible != false ? "0" : "0x20");
        }
        this.addParameter(params, "format", "json");
        JSONObject jsonObject = new JSONObject(this.post("https://graph.qq.com/t/add_t", params));
        Error error = Error.parse(jsonObject);
        if (error != null) {
            return new Result<Error>(error);
        }
        return Result.parse(jsonObject.getJSONObject("data"), NewT.class);
    }

    public Result<Error> delT(String accessToken, String openId, String id) {
        return this.delT(accessToken, this.getClientId(), openId, id);
    }

    public Result<NewT> addPicT(String accessToken, String openId, String content, byte[] pic) {
        return this.addPicT(accessToken, this.getClientId(), openId, content, pic);
    }

    public Result<NewT> addPicT(String accessToken, String oauthConsumerKey, String openId, String content, byte[] pic) {
        return this.addPicT(accessToken, oauthConsumerKey, openId, content, pic, null, null, null, true, true);
    }

    public Result<NewT> addPicT(String accessToken, String oauthConsumerKey, String openId, String content, byte[] pic, String clientIp, Double lon, Double lat, Boolean sync, Boolean compatible) {
        HttpPost request = new HttpPost("https://graph.qq.com/t/add_pic_t");
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().addBinaryBody("pic", pic);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addParameter(params, "access_token", accessToken);
        this.addParameter(params, "oauth_consumer_key", oauthConsumerKey);
        this.addParameter(params, "openid", openId);
        this.addParameter(params, "content", content);
        this.addNotNullParameter(params, "clientip", clientIp);
        this.addNotNullParameter(params, "lon", lon);
        this.addNotNullParameter(params, "lat", lat);
        if (sync != null) {
            this.addParameter(params, "syncflag", sync != false ? "0" : "1");
        }
        if (compatible != null) {
            this.addParameter(params, "compatibleflag", compatible != false ? "0" : "0x20");
        }
        this.addParameter(params, "format", "json");
        for (NameValuePair nameValuePair : params) {
            builder.addTextBody(nameValuePair.getName(), nameValuePair.getValue());
        }
        request.setEntity(builder.build());
        try {
            HttpResponse response = Http.CLIENT.execute((HttpUriRequest)request);
            String json = IOUtils.toString((InputStream)response.getEntity().getContent());
            JSONObject jsonObject = new JSONObject(json);
            Error error = Error.parse(jsonObject);
            if (error != null) {
                Result<Error> result = new Result<Error>(error);
                return result;
            }
            Result<NewT> result = Result.parse(jsonObject.getJSONObject("data"), NewT.class);
            return result;
        }
        catch (ClientProtocolException e) {
            throw new SocialException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SocialException(e);
        }
        finally {
            request.releaseConnection();
        }
    }

    public Result<Error> delT(String accessToken, String oauthConsumerKey, String openId, String id) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addParameter(params, "access_token", accessToken);
        this.addParameter(params, "oauth_consumer_key", oauthConsumerKey);
        this.addParameter(params, "openid", openId);
        this.addParameter(params, "id", id);
        this.addParameter(params, "format", "json");
        return Result.parse(this.post("https://graph.qq.com/t/del_t", params), Error.class);
    }

    public Result<List<TenpayAddress>> getTenpayAddr(String accessToken, String openId) {
        return this.getTenpayAddr(accessToken, this.getClientId(), openId, 0, Integer.MAX_VALUE);
    }

    public Result<List<TenpayAddress>> getTenpayAddr(String accessToken, String openId, Integer offset, Integer limit) {
        return this.getTenpayAddr(accessToken, this.getClientId(), openId, offset, limit);
    }

    public Result<List<TenpayAddress>> getTenpayAddr(String accessToken, String oauthConsumerKey, String openId, Integer offset, Integer limit) {
        Integer index;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.addParameter(params, "access_token", accessToken);
        this.addParameter(params, "oauth_consumer_key", oauthConsumerKey);
        this.addParameter(params, "openid", openId);
        this.addParameter(params, "offset", offset == null ? "0" : offset);
        this.addParameter(params, "limit", limit == null ? "5" : limit);
        this.addParameter(params, "ver", "1");
        this.addParameter(params, "format", "json");
        JSONObject jsonObject = new JSONObject(this.post("https://graph.qq.com/cft_info/get_tenpay_addr", params));
        Error error = Error.parse(jsonObject);
        if (error != null) {
            return new Result<Error>(error);
        }
        ArrayList addresses = new ArrayList();
        Integer total = Result.parseInteger(jsonObject.get("ret_num"));
        for (int i = 0; i < total && (index = Result.parseInteger(jsonObject.opt("Findex_" + i))) != null; ++i) {
            TenpayAddress address = new TenpayAddress();
            address.setTotal(total);
            address.setIndex(index);
            address.setRegionId(Result.parseInteger(jsonObject.opt("FRegionId_" + i)));
            address.setStreet(jsonObject.optString("Faddrstreet_" + i));
            address.setZipcode(Result.toString(jsonObject.opt("Fzipcode_" + i)));
            address.setMobile(Result.toString(jsonObject.opt("Fmobile_" + i)));
            address.setTel(Result.toString(jsonObject.opt("Ftel_" + i)));
            address.setName(Result.toString(jsonObject.opt("Fname_" + i)));
            address.setCreated(Result.parseDate(jsonObject.opt("Fcreate_time_" + i), "yyyy-MM-dd HH:mm:ss", Locale.CHINA));
            address.setModified(Result.parseDate(jsonObject.opt("Fmod_time_" + i), "yyyy-MM-dd HH:mm:ss", Locale.CHINA));
            address.setLastUsed(Result.parseDate(jsonObject.opt("Flastuse_time_" + i), "yyyy-MM-dd HH:mm:ss", Locale.CHINA));
            address.setUsedCount(Result.parseInteger(jsonObject.opt("FUsedCount_" + i)));
        }
        return new Result<List<TenpayAddress>>(addresses);
    }

    public OAuth2 getOAuth2() {
        if (this.oAuth2 == null) {
            this.oAuth2 = new OAuth2(this);
        }
        return this.oAuth2;
    }

    public User getUser() {
        if (this.user == null) {
            this.user = new User(this);
        }
        return this.user;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }
}

