/*
 * Decompiled with CFR 0.152.
 */
package com.belerweb.social.mail.api;

import com.belerweb.social.exception.SocialException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.SocketException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.pop3.POP3Client;
import org.apache.commons.net.pop3.POP3MessageInfo;
import org.apache.commons.net.pop3.POP3SClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POP3 {
    private static final Logger LOGGER = LoggerFactory.getLogger(POP3.class);
    private String username;
    private String password;
    private String host;
    private int port;
    private POP3Client client;

    public POP3(String username, String password, String host) {
        this(username, password, host, 110, false);
    }

    public POP3(String username, String password, String host, int port, boolean ssl) {
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = port;
        this.client = ssl ? new POP3SClient("SSL", true) : new POP3Client();
        this.client.setDefaultTimeout(300000);
    }

    private boolean login() throws SocketException, IOException {
        this.client.connect(this.host, this.port);
        return this.client.login(this.username, this.password);
    }

    public boolean test() throws SocialException {
        try {
            boolean bl = this.login();
            return bl;
        }
        catch (SocketException e) {
            e.printStackTrace();
            throw new SocialException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SocialException(e);
        }
        finally {
            try {
                this.client.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(File dir) throws SocialException {
        if (!dir.isDirectory() || !dir.canWrite()) {
            throw new SocialException("The specified directory is unavailable.");
        }
        try {
            if (this.login()) {
                POP3MessageInfo[] messages = this.client.listUniqueIdentifiers();
                if (messages == null) {
                    LOGGER.debug("Could not retrieve message list.");
                    throw new SocialException("Could not retrieve message list.");
                }
                for (POP3MessageInfo message : messages) {
                    File eml = new File(dir, this.username + "@" + this.host + "/" + message.identifier + ".eml");
                    try {
                        Reader reader = this.client.retrieveMessage(message.number);
                        if (reader == null) {
                            LOGGER.debug("Could not retrieve message.");
                            continue;
                        }
                        if (eml.exists() && (message.size > 0 && eml.length() == (long)message.size || eml.length() > 1000L)) {
                            LOGGER.debug("Message {} exist, skip download.", (Object)message.identifier);
                            continue;
                        }
                        eml.getParentFile().mkdirs();
                        LOGGER.debug("Downloading {} ...", (Object)message.identifier);
                        IOUtils.copy((Reader)reader, (OutputStream)new FileOutputStream(eml));
                        LOGGER.debug("Downloaded {} ...", (Object)message.identifier);
                    }
                    catch (Exception e) {
                        try {
                            FileUtils.forceDelete((File)eml);
                        }
                        catch (Exception exception) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.client.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void download(String dir) {
        this.download(new File(dir));
    }
}

