/*
 * Decompiled with CFR 0.152.
 */
package com.belerweb.social.captcha.api;

import com.belerweb.social.bean.Error;
import com.belerweb.social.bean.Result;
import com.belerweb.social.captcha.bean.YundamaType;
import com.belerweb.social.exception.SocialException;
import com.belerweb.social.http.Http;
import com.belerweb.social.http.HttpException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Yundama {
    private String appId = "85";
    private String appKey = "19fcd07d8de9c03b8cebec5d8bfe7d8e";
    private String username;
    private String password;

    public Yundama(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public Result<String> decode(byte[] img, YundamaType type) {
        HttpPost request = new HttpPost("http://api.yundama.com/api.php?method=upload");
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().addBinaryBody("file", img, ContentType.create((String)"image/png"), "code.png").addTextBody("username", this.username).addTextBody("password", this.password).addTextBody("codetype", type.getType().toString()).addTextBody("appid", this.appId).addTextBody("appkey", this.appKey).addTextBody("timeout", "60");
        request.setEntity(builder.build());
        try {
            HttpResponse response = Http.CLIENT.execute((HttpUriRequest)request);
            String json = IOUtils.toString((InputStream)response.getEntity().getContent());
            request.releaseConnection();
            JSONObject jsonObject = new JSONObject(json);
            Integer ret = Result.parseInteger(jsonObject.get("ret"));
            if (ret == 0) {
                String url = "http://api.yundama.com/api.php?method=result&cid=" + Result.toString(jsonObject.get("cid"));
                long start = System.currentTimeMillis();
                while (true) {
                    if (Result.parseInteger((jsonObject = new JSONObject(Http.get(url, new Header[0]))).get("ret")) == 0) {
                        return new Result<String>(Result.toString(jsonObject.get("text")));
                    }
                    if (System.currentTimeMillis() - start > 10000L) {
                        return new Result<Error>(new Error("TIMEOUT", "\u9a8c\u8bc1\u7801\u8bc6\u522b\u8d85\u65f6\u3002"));
                    }
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            Error error = new Error();
            error.setErrorCode(ret.toString());
            return new Result<Error>(error);
        }
        catch (ClientProtocolException e) {
            throw new SocialException((Exception)((Object)e));
        }
        catch (HttpException e) {
            throw new SocialException(e);
        }
        catch (IOException e) {
            throw new SocialException(e);
        }
    }
}

