/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.pay.model.enums;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum PayChannelType {
    WEIXIN_NATIVE(1, "\u5fae\u4fe1\u626b\u7801\u652f\u4ed8", "weixin"),
    WEIXIN_APP(2, "\u5fae\u4fe1APP\u652f\u4ed8", "weixin"),
    WEIXIN_H5(3, "\u5fae\u4fe1\u624b\u673a\u7f51\u7ad9\u652f\u4ed8", "weixin"),
    WEIXIN_JSAPI(4, "\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8", "weixin"),
    WEIXIN_WEAPPLET(5, "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u652f\u4ed8", "weixin"),
    WEIXIN_PRE_CREATE(6, "\u5fae\u4fe1\u5f53\u9762\u4ed8", "weixin"),
    ALIPAY_PRE_CREATE(7, "\u652f\u4ed8\u5b9d\u5f53\u9762\u4ed8-\u626b\u7801\u652f\u4ed8", "alipay"),
    ALIPAY_APP(8, "\u652f\u4ed8\u5b9dAPP\u652f\u4ed8", "alipay"),
    ALIPAY_WAP(9, "\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed8", "alipay"),
    ALIPAY_PAGE(10, "\u652f\u4ed8\u5b9d\u7535\u8111\u7f51\u7ad9\u652f\u4ed8", "alipay"),
    OFFLINE_CASH(11, "\u7ebf\u4e0b\u73b0\u91d1\u652f\u4ed8", "offline"),
    OFFLINE_POS(12, "\u7ebf\u4e0bPOS\u673a\u5237\u5361", "offline"),
    OFFLINE_QW_PAYMENT_CODE(13, "\u7ebf\u4e0b\u4f01\u5fae\u6536\u6b3e\u7801", "offline"),
    OFFLINE_REMAIN(14, "\u7ebf\u4e0b\u7ed3\u4f59\u652f\u4ed8", "offline");

    static Map<Integer, PayChannelType> MAP;
    private Integer value;
    private String desc;
    private String serviceCode;

    private PayChannelType(Integer value, String desc, String serviceCode) {
        this.value = value;
        this.desc = desc;
        this.serviceCode = serviceCode;
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public static PayChannelType get(Integer value) {
        return MAP.get(value);
    }

    static {
        MAP = ImmutableMap.copyOf(Arrays.stream(PayChannelType.values()).collect(Collectors.toMap(PayChannelType::getValue, e -> e)));
    }
}

