/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.pay.model.dto.response;

import com.baijiayun.duanxunbao.common.enums.ResultCode;
import java.io.Serializable;

public class BaseResponse<T>
implements Serializable {
    private String requestId;
    private boolean success;
    private int code;
    private String msg;
    private String thirdPartCode;
    private String thirdPartMsg;
    private T data;

    public static BaseResponse serviceError(String errMsg) {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setSuccess(false);
        baseResponse.setCode(500);
        baseResponse.setMsg(errMsg);
        return baseResponse;
    }

    public static BaseResponse fail(String thirdPartCode, String thirdPartMsg) {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setSuccess(false);
        baseResponse.setCode(500);
        baseResponse.setMsg("\u4e1a\u52a1\u6267\u884c\u5931\u8d25");
        baseResponse.setThirdPartCode(thirdPartCode);
        baseResponse.setThirdPartMsg(thirdPartMsg);
        return baseResponse;
    }

    public static BaseResponse paramsError(String errMsg) {
        return BaseResponse.paramsError(errMsg, null);
    }

    public static BaseResponse paramsError(String errMsg, String requestId) {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setSuccess(false);
        baseResponse.setCode(400);
        baseResponse.setMsg(errMsg);
        baseResponse.setRequestId(requestId);
        return baseResponse;
    }

    public static BaseResponse ok(Serializable data) {
        return BaseResponse.ok(data, null);
    }

    public static BaseResponse ok(Serializable data, String requestId) {
        BaseResponse<Serializable> baseResponse = new BaseResponse<Serializable>();
        baseResponse.setSuccess(true);
        baseResponse.setCode(0);
        baseResponse.setData(data);
        baseResponse.setRequestId(requestId);
        return baseResponse;
    }

    public static BaseResponse error(ResultCode resultCode, String msg) {
        return BaseResponse.error(resultCode.getCode(), msg, null);
    }

    public static BaseResponse error(ResultCode resultCode, String msg, String requestId) {
        return BaseResponse.error(resultCode.getCode(), msg, requestId);
    }

    public static BaseResponse error(int code, String msg) {
        return BaseResponse.error(code, msg, null);
    }

    public static BaseResponse error(int code, String msg, String requestId) {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setSuccess(false);
        baseResponse.setCode(code);
        baseResponse.setMsg(msg);
        baseResponse.setRequestId(requestId);
        return baseResponse;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getThirdPartCode() {
        return this.thirdPartCode;
    }

    public String getThirdPartMsg() {
        return this.thirdPartMsg;
    }

    public T getData() {
        return this.data;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setThirdPartCode(String thirdPartCode) {
        this.thirdPartCode = thirdPartCode;
    }

    public void setThirdPartMsg(String thirdPartMsg) {
        this.thirdPartMsg = thirdPartMsg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseResponse)) {
            return false;
        }
        BaseResponse other = (BaseResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        String this$thirdPartCode = this.getThirdPartCode();
        String other$thirdPartCode = other.getThirdPartCode();
        if (this$thirdPartCode == null ? other$thirdPartCode != null : !this$thirdPartCode.equals(other$thirdPartCode)) {
            return false;
        }
        String this$thirdPartMsg = this.getThirdPartMsg();
        String other$thirdPartMsg = other.getThirdPartMsg();
        if (this$thirdPartMsg == null ? other$thirdPartMsg != null : !this$thirdPartMsg.equals(other$thirdPartMsg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        result = result * 59 + this.getCode();
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        String $thirdPartCode = this.getThirdPartCode();
        result = result * 59 + ($thirdPartCode == null ? 43 : $thirdPartCode.hashCode());
        String $thirdPartMsg = this.getThirdPartMsg();
        result = result * 59 + ($thirdPartMsg == null ? 43 : $thirdPartMsg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "BaseResponse(requestId=" + this.getRequestId() + ", success=" + this.isSuccess() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ", thirdPartCode=" + this.getThirdPartCode() + ", thirdPartMsg=" + this.getThirdPartMsg() + ", data=" + this.getData() + ")";
    }
}

