/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.pay.model.dto.request;

import com.baijiayun.duanxunbao.pay.model.dto.request.BaseRequest;
import com.baijiayun.duanxunbao.pay.model.enums.SourceType;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class RefundRequest
extends BaseRequest {
    private String amount;
    private String bizRefundNum;
    private String bizOrderNum;
    private String refundReason;
    private Integer sourceType;

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.amount) && this.amount.matches("\\d+") ? 1 : 0) != 0, (Object)"\u65e0\u6548\u7684amount,\u91d1\u989d\u5fc5\u987b\u4ee5\u5206\u4e3a\u5355\u4f4d,\u4e14\u662f\u4e00\u4e2a\u6b63\u6574\u6570");
        Long totalAmountNum = NumberUtils.toLong((String)this.amount);
        Preconditions.checkArgument((totalAmountNum > 0L && totalAmountNum < 100000000000L ? 1 : 0) != 0, (Object)"amount\u53d6\u503c\u8303\u56f4\u4e3a:[1,100000000000)");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.bizRefundNum), (Object)"bizRefundNum \u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.bizOrderNum), (Object)"bizOrderNum \u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.refundReason), (Object)"refundReason \u4e0d\u80fd\u4e3a\u7a7a");
        if (Objects.isNull(this.sourceType)) {
            this.sourceType = SourceType.DEFAULT.getType();
        }
    }

    public String getAmount() {
        return this.amount;
    }

    public String getBizRefundNum() {
        return this.bizRefundNum;
    }

    public String getBizOrderNum() {
        return this.bizOrderNum;
    }

    public String getRefundReason() {
        return this.refundReason;
    }

    public Integer getSourceType() {
        return this.sourceType;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public void setBizRefundNum(String bizRefundNum) {
        this.bizRefundNum = bizRefundNum;
    }

    public void setBizOrderNum(String bizOrderNum) {
        this.bizOrderNum = bizOrderNum;
    }

    public void setRefundReason(String refundReason) {
        this.refundReason = refundReason;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RefundRequest)) {
            return false;
        }
        RefundRequest other = (RefundRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$sourceType = this.getSourceType();
        Integer other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !((Object)this$sourceType).equals(other$sourceType)) {
            return false;
        }
        String this$amount = this.getAmount();
        String other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        String this$bizRefundNum = this.getBizRefundNum();
        String other$bizRefundNum = other.getBizRefundNum();
        if (this$bizRefundNum == null ? other$bizRefundNum != null : !this$bizRefundNum.equals(other$bizRefundNum)) {
            return false;
        }
        String this$bizOrderNum = this.getBizOrderNum();
        String other$bizOrderNum = other.getBizOrderNum();
        if (this$bizOrderNum == null ? other$bizOrderNum != null : !this$bizOrderNum.equals(other$bizOrderNum)) {
            return false;
        }
        String this$refundReason = this.getRefundReason();
        String other$refundReason = other.getRefundReason();
        return !(this$refundReason == null ? other$refundReason != null : !this$refundReason.equals(other$refundReason));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RefundRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : ((Object)$sourceType).hashCode());
        String $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        String $bizRefundNum = this.getBizRefundNum();
        result = result * 59 + ($bizRefundNum == null ? 43 : $bizRefundNum.hashCode());
        String $bizOrderNum = this.getBizOrderNum();
        result = result * 59 + ($bizOrderNum == null ? 43 : $bizOrderNum.hashCode());
        String $refundReason = this.getRefundReason();
        result = result * 59 + ($refundReason == null ? 43 : $refundReason.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RefundRequest(amount=" + this.getAmount() + ", bizRefundNum=" + this.getBizRefundNum() + ", bizOrderNum=" + this.getBizOrderNum() + ", refundReason=" + this.getRefundReason() + ", sourceType=" + this.getSourceType() + ")";
    }
}

