/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.pay.model.dto.request;

import com.baijiayun.duanxunbao.pay.model.dto.request.PayCertBase64Dto;
import com.baijiayun.duanxunbao.pay.model.dto.request.PayConfigBaseReq;
import com.baijiayun.duanxunbao.pay.model.enums.PayChannelCode;
import com.baijiayun.duanxunbao.pay.model.enums.PayChannelType;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PayConfigAddReq
extends PayConfigBaseReq
implements Serializable {
    private String businessName;
    private String mchId;
    private String mchName;
    private Integer payChannelType;
    private String secret;
    private String alipayAppPrivateKey;
    private List<PayCertBase64Dto> payCerts;
    private String appId;
    private Long operatorId;
    private static final Set<String> WEIXIN_CERT_NAMES = Sets.newHashSet((Object[])new String[]{"apiclient_cert.p12", "apiclient_cert.pem", "apiclient_key.pem"});
    private static final Set<String> ALIPAY_CERT_NAMES = Sets.newHashSet((Object[])new String[]{"alipayCertPublicKey_RSA2.crt", "alipayRootCert.crt"});

    /*
     * WARNING - void declaration
     */
    @Override
    public void validate() {
        Set fileNames;
        Collection notMatchFileNames;
        super.validate();
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.businessName) && StringUtils.length((CharSequence)this.businessName) <= 32 ? 1 : 0) != 0, (Object)"businessName is null or empty, and length no more then 32");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.mchId) && StringUtils.length((CharSequence)this.mchId) <= 20 ? 1 : 0) != 0, (Object)"mchId can not be null or empty,and length no more then 20");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.mchName) && StringUtils.length((CharSequence)this.mchName) <= 64 ? 1 : 0) != 0, (Object)"mchName can not be null or empty, and length no more then 64");
        Preconditions.checkArgument((Objects.nonNull(this.payChannelType) && Objects.nonNull((Object)PayChannelType.get(this.payChannelType)) ? 1 : 0) != 0, (Object)"payChannelType can not be null or empty");
        Preconditions.checkArgument((!CollectionUtils.isEmpty(this.payCerts) ? 1 : 0) != 0, (Object)"payCerts can not be null or empty");
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.appId) && StringUtils.length((CharSequence)this.appId) <= 64 ? 1 : 0) != 0, (Object)"appId can not be null or empty, and length no more then 64");
        if (Objects.equals(PayChannelType.get(this.payChannelType).getServiceCode(), PayChannelCode.PAY_CHANNEL_CODE_WEIXIN.getValue())) {
            Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.secret) && StringUtils.length((CharSequence)this.secret) == 32 ? 1 : 0) != 0, (Object)"\u5fae\u4fe1\u652f\u4ed8\u79d8\u94a5secret\u4e3a32\u4f4d\u6570\u5b57\uff0c\u8bf7\u68c0\u67e5");
            Preconditions.checkArgument((CollectionUtils.size(this.payCerts) == 3 ? 1 : 0) != 0, (Object)"\u5fae\u4fe1\u652f\u4ed8\u8bc1\u4e66\u67093\u4e2a\u6587\u4ef6");
        } else if (Objects.equals(PayChannelType.get(this.payChannelType).getServiceCode(), PayChannelCode.PAY_CHANNEL_CODE_ALIPAY.getValue())) {
            Preconditions.checkArgument((CollectionUtils.size(this.payCerts) == 3 ? 1 : 0) != 0, (Object)"\u652f\u4ed8\u5b9d\u652f\u4ed8\u8bc1\u4e66\u67093\u4e2a\u6587\u4ef6");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.alipayAppPrivateKey), (Object)"alipayAppPrivateKey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (PayCertBase64Dto payCert : this.payCerts) {
            payCert.validate();
        }
        if (PayChannelType.get(this.payChannelType).getServiceCode().equals(PayChannelCode.PAY_CHANNEL_CODE_ALIPAY.getValue())) {
            void var4_11;
            Map fileName2Dto = this.payCerts.stream().collect(Collectors.toMap(a -> a.getCertName(), Function.identity()));
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : ALIPAY_CERT_NAMES) {
                PayCertBase64Dto dto = (PayCertBase64Dto)fileName2Dto.get(string);
                if (!Objects.isNull(dto)) continue;
                stringBuilder.append(string).append(",");
            }
            boolean findAppCertPublicKey = false;
            for (PayCertBase64Dto payCert : this.payCerts) {
                if (!payCert.getCertName().matches("appCertPublicKey_\\d+\\.crt")) continue;
                findAppCertPublicKey = true;
            }
            if (!findAppCertPublicKey) {
                stringBuilder.append("appCertPublicKey_xxxxxx.crt").append(",");
            }
            String string = "";
            if (StringUtils.isNotBlank((CharSequence)stringBuilder.toString())) {
                String string3 = stringBuilder.substring(0, stringBuilder.length() - 1);
                string3 = string3 + "\u8bc1\u4e66\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5";
            }
            Preconditions.checkArgument((boolean)StringUtils.isEmpty((CharSequence)var4_11), (Object)var4_11);
        }
        if (PayChannelType.get(this.payChannelType).getServiceCode().equals(PayChannelCode.PAY_CHANNEL_CODE_WEIXIN.getValue()) && CollectionUtils.isNotEmpty((Collection)(notMatchFileNames = CollectionUtils.subtract(WEIXIN_CERT_NAMES, fileNames = this.payCerts.stream().map(a -> a.getCertName()).collect(Collectors.toSet()))))) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String notMatchFileName : notMatchFileNames) {
                stringBuilder.append(notMatchFileName).append(",");
            }
            String string = stringBuilder.substring(0, stringBuilder.length() - 1);
            Preconditions.checkArgument((boolean)StringUtils.isEmpty((CharSequence)string), (Object)string);
        }
        Preconditions.checkArgument((boolean)Objects.nonNull(this.operatorId), (Object)"operatorId \u4e0d\u80fd\u4e3a\u7a7a");
    }

    public String findAlipayAppCert() {
        String appCertName = null;
        if (PayChannelType.get(this.payChannelType).getServiceCode().equals(PayChannelCode.PAY_CHANNEL_CODE_ALIPAY.getValue())) {
            for (PayCertBase64Dto payCert : this.payCerts) {
                if (!payCert.getCertName().matches("appCertPublicKey_\\d+\\.crt")) continue;
                appCertName = payCert.getCertName();
            }
        }
        return appCertName;
    }

    public String getBusinessName() {
        return this.businessName;
    }

    public String getMchId() {
        return this.mchId;
    }

    public String getMchName() {
        return this.mchName;
    }

    public Integer getPayChannelType() {
        return this.payChannelType;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getAlipayAppPrivateKey() {
        return this.alipayAppPrivateKey;
    }

    public List<PayCertBase64Dto> getPayCerts() {
        return this.payCerts;
    }

    public String getAppId() {
        return this.appId;
    }

    public Long getOperatorId() {
        return this.operatorId;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public void setMchName(String mchName) {
        this.mchName = mchName;
    }

    public void setPayChannelType(Integer payChannelType) {
        this.payChannelType = payChannelType;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setAlipayAppPrivateKey(String alipayAppPrivateKey) {
        this.alipayAppPrivateKey = alipayAppPrivateKey;
    }

    public void setPayCerts(List<PayCertBase64Dto> payCerts) {
        this.payCerts = payCerts;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PayConfigAddReq)) {
            return false;
        }
        PayConfigAddReq other = (PayConfigAddReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$payChannelType = this.getPayChannelType();
        Integer other$payChannelType = other.getPayChannelType();
        if (this$payChannelType == null ? other$payChannelType != null : !((Object)this$payChannelType).equals(other$payChannelType)) {
            return false;
        }
        Long this$operatorId = this.getOperatorId();
        Long other$operatorId = other.getOperatorId();
        if (this$operatorId == null ? other$operatorId != null : !((Object)this$operatorId).equals(other$operatorId)) {
            return false;
        }
        String this$businessName = this.getBusinessName();
        String other$businessName = other.getBusinessName();
        if (this$businessName == null ? other$businessName != null : !this$businessName.equals(other$businessName)) {
            return false;
        }
        String this$mchId = this.getMchId();
        String other$mchId = other.getMchId();
        if (this$mchId == null ? other$mchId != null : !this$mchId.equals(other$mchId)) {
            return false;
        }
        String this$mchName = this.getMchName();
        String other$mchName = other.getMchName();
        if (this$mchName == null ? other$mchName != null : !this$mchName.equals(other$mchName)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        String this$alipayAppPrivateKey = this.getAlipayAppPrivateKey();
        String other$alipayAppPrivateKey = other.getAlipayAppPrivateKey();
        if (this$alipayAppPrivateKey == null ? other$alipayAppPrivateKey != null : !this$alipayAppPrivateKey.equals(other$alipayAppPrivateKey)) {
            return false;
        }
        List<PayCertBase64Dto> this$payCerts = this.getPayCerts();
        List<PayCertBase64Dto> other$payCerts = other.getPayCerts();
        if (this$payCerts == null ? other$payCerts != null : !((Object)this$payCerts).equals(other$payCerts)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        return !(this$appId == null ? other$appId != null : !this$appId.equals(other$appId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PayConfigAddReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $payChannelType = this.getPayChannelType();
        result = result * 59 + ($payChannelType == null ? 43 : ((Object)$payChannelType).hashCode());
        Long $operatorId = this.getOperatorId();
        result = result * 59 + ($operatorId == null ? 43 : ((Object)$operatorId).hashCode());
        String $businessName = this.getBusinessName();
        result = result * 59 + ($businessName == null ? 43 : $businessName.hashCode());
        String $mchId = this.getMchId();
        result = result * 59 + ($mchId == null ? 43 : $mchId.hashCode());
        String $mchName = this.getMchName();
        result = result * 59 + ($mchName == null ? 43 : $mchName.hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        String $alipayAppPrivateKey = this.getAlipayAppPrivateKey();
        result = result * 59 + ($alipayAppPrivateKey == null ? 43 : $alipayAppPrivateKey.hashCode());
        List<PayCertBase64Dto> $payCerts = this.getPayCerts();
        result = result * 59 + ($payCerts == null ? 43 : ((Object)$payCerts).hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PayConfigAddReq(businessName=" + this.getBusinessName() + ", mchId=" + this.getMchId() + ", mchName=" + this.getMchName() + ", payChannelType=" + this.getPayChannelType() + ", secret=" + this.getSecret() + ", alipayAppPrivateKey=" + this.getAlipayAppPrivateKey() + ", payCerts=" + this.getPayCerts() + ", appId=" + this.getAppId() + ", operatorId=" + this.getOperatorId() + ")";
    }
}

