/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.excel;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ReadConverterContext;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SetConvertor
implements Converter<Set<String>> {
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public Class<?> supportJavaTypeKey() {
        return List.class;
    }

    public Set<String> convertToJavaData(ReadConverterContext<?> context) {
        String stringValue = context.getReadCellData().getStringValue();
        HashSet result = Sets.newHashSet();
        result.addAll(Splitter.on((String)",").splitToList((CharSequence)stringValue));
        return result;
    }

    public WriteCellData<?> convertToExcelData(WriteConverterContext<Set<String>> context) {
        Set set = (Set)context.getValue();
        WriteCellData result = new WriteCellData();
        if (CollectionUtils.isNotEmpty((Collection)set)) {
            if (CollectionUtils.isNotEmpty(set = set.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet()))) {
                result.setStringValue(Joiner.on((String)",").join(set));
            } else {
                result.setStringValue("");
            }
        } else {
            result.setStringValue("");
        }
        result.setType(CellDataTypeEnum.STRING);
        return result;
    }
}

