/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.excel;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.WriteCellData;
import java.util.List;

public class PriceConvertor
implements Converter<Long> {
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public Class<?> supportJavaTypeKey() {
        return List.class;
    }

    public WriteCellData<?> convertToExcelData(WriteConverterContext<Long> context) {
        String value;
        Long price = (Long)context.getValue();
        if (price == null) {
            value = "0";
        } else {
            double priceInYuan = (double)price.longValue() / 10000.0;
            value = Double.toString(priceInYuan);
        }
        WriteCellData result = new WriteCellData();
        result.setStringValue(value);
        result.setType(CellDataTypeEnum.STRING);
        return result;
    }
}

