/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.excel;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ReadConverterContext;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ListConvertor
implements Converter<List<String>> {
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public Class<?> supportJavaTypeKey() {
        return List.class;
    }

    public List<String> convertToJavaData(ReadConverterContext<?> context) {
        String stringValue = context.getReadCellData().getStringValue();
        return Splitter.on((String)",").splitToList((CharSequence)stringValue);
    }

    public WriteCellData<?> convertToExcelData(WriteConverterContext<List<String>> context) {
        List list = (List)context.getValue();
        WriteCellData result = new WriteCellData();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            if (CollectionUtils.isNotEmpty(list = list.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList()))) {
                result.setStringValue(Joiner.on((String)",").join(list));
            } else {
                result.setStringValue("");
            }
        } else {
            result.setStringValue("");
        }
        result.setType(CellDataTypeEnum.STRING);
        return result;
    }
}

