/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.excel;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileDownloadConvertor {
    private static final Logger log = LoggerFactory.getLogger(FileDownloadConvertor.class);

    private FileDownloadConvertor() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File convertor(String imgUrl, String filePath, String fileName) {
        log.info("convertor imgUrl: {}, path: {}", (Object)imgUrl, (Object)filePath);
        File imageFile = new File(filePath, fileName);
        try (OutputStream outputStream = Files.newOutputStream(imageFile.toPath(), new OpenOption[0]);){
            int bytesRead;
            URL url = new URL(imgUrl);
            URLConnection connection = url.openConnection();
            InputStream inputStream = connection.getInputStream();
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            inputStream.close();
            File file = imageFile;
            return file;
        }
        catch (Exception e) {
            log.error("convertor url with error", (Throwable)e);
            return null;
        }
    }
}

