/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.enums;

import com.baijiayun.duanxunbao.common.enums.EnumService;
import com.baijiayun.duanxunbao.common.enums.ShelfModeEnum;
import java.util.HashMap;
import java.util.Map;

public enum ShelfStatusEnum implements EnumService
{
    DELETED(0, "\u5df2\u5220\u9664"),
    ON_SHELF(1, "\u5df2\u4e0a\u67b6"),
    DOWN_SHELF(2, "\u5df2\u4e0b\u67b6"),
    WAITING_SHELF(3, "\u7b49\u5f85\u4e0a\u67b6");

    private final int value;
    private final String desc;
    private static final Map<Integer, ShelfStatusEnum> CACHE;

    private ShelfStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    public static ShelfStatusEnum get(int value) {
        return CACHE.get(value);
    }

    public static int getStatusByMode(int shellMode) {
        if (ShelfModeEnum.IMMEDIATELY.getValue() == shellMode) {
            return ON_SHELF.getValue();
        }
        if (ShelfModeEnum.CLOCKING.getValue() == shellMode) {
            return WAITING_SHELF.getValue();
        }
        if (ShelfModeEnum.NOT_YET.getValue() == shellMode) {
            return DELETED.getValue();
        }
        return DELETED.getValue();
    }

    static {
        CACHE = new HashMap<Integer, ShelfStatusEnum>();
        for (ShelfStatusEnum item : ShelfStatusEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }
}

