/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.enums;

import com.baijiayun.duanxunbao.common.dto.ResultError;
import com.google.common.collect.Maps;
import java.util.Map;

public enum ResultCode implements ResultError
{
    SUCCESS(200, "\u6210\u529f"),
    USER_ERROR(10001, "\u7528\u6237\u8bf7\u6c42\u670d\u52a1\u5f02\u5e38"),
    USER_SIGN_ERROR(10002, "\u7b7e\u540d\u6821\u9a8c\u5931\u8d25"),
    USER_DOMAIN_NOT_FOUND(10003, "\u7528\u6237\u57df\u540d\u4e0d\u5b58\u5728"),
    USER_LOGIN_FAILED(10100, "\u7528\u6237\u767b\u5f55\u5931\u8d25"),
    USER_INVALID_PASSWORD(10101, "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef"),
    USER_INVALID_CAPTCHA(10102, "\u9a8c\u8bc1\u7801\u9519\u8bef"),
    USER_LOGIN_EXPIRED(10103, "\u767b\u5f55\u8d85\u65f6"),
    USER_PASSWORD_NOT_SET(10104, "\u8d26\u53f7\u672a\u4fee\u6539\u8fc7\u5bc6\u7801\uff0c\u8bf7\u5148\u4fee\u6539\u5bc6\u7801\u518d\u767b\u5f55"),
    USER_ACCOUNT_OVER_LIMIT(10105, "\u767b\u5f55\u5931\u8d25\uff0c\u8d26\u53f7\u8d85\u8fc7\u9650\u5236"),
    USER_USERINFO_NOT_FOUND(10106, "\u767b\u5f55\u5931\u8d25\uff0c\u9700\u8981\u5fae\u4fe1\u6388\u6743"),
    USER_NO_AUTH(10200, "\u60a8\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u8be5\u64cd\u4f5c"),
    USER_AUTH_EXPIRED(10201, "\u6388\u6743\u5df2\u8fc7\u671f"),
    USER_NOT_LOGIN(10202, "\u7528\u6237\u672a\u767b\u5f55"),
    USER_TOKEN_EXPIRE(10203, "\u7528\u6237token\u8fc7\u671f"),
    USER_TOKEN_INVALID(10204, "\u7528\u6237token\u65e0\u6548"),
    USER_DISABLED(10205, "\u8d26\u53f7\u5df2\u7981\u7528"),
    USER_IN_BLACKLIST(10206, "\u6682\u65e0\u8bbf\u95ee\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002"),
    USER_PARAM_ERROR(10300, "\u7528\u6237\u8bf7\u6c42\u53c2\u6570\u9519\u8bef"),
    USER_PARAM_REQUIRED(10301, "\u7f3a\u5c11\u5fc5\u8981\u7684\u8bf7\u6c42\u53c2\u6570"),
    USER_REGISTER_FAILED(10400, "\u7528\u6237\u6ce8\u518c\u5931\u8d25"),
    USER_REGISTERED(10410, "\u7528\u6237\u5df2\u6ce8\u518c"),
    USER_MOBILE_REGISTERED(10411, "\u7528\u6237\u624b\u673a\u53f7\u5df2\u6ce8\u518c"),
    USER_UNIONID_REGISTERED(10412, "\u7528\u6237unionid\u5df2\u6ce8\u518c"),
    USER_TICKET_INVALID(10500, "\u7528\u6237ticket\u65e0\u6548"),
    USER_TICKET_EXPIRED(10501, "\u7528\u6237ticket\u8fc7\u671f"),
    USER_TICKET_NOT_FOUND(10502, "\u7528\u6237ticket\u4e0d\u5b58\u5728"),
    USER_TICKET_EXISTS(10503, "\u7528\u6237ticket\u5df2\u5b58\u5728"),
    OPENAPI_INVALID_TOKEN(10600, "\u65e0\u6548\u7684Token"),
    OPENAPI_INVALID_CALLBACK_URL(10601, "\u65e0\u6548\u7684\u56de\u8c03\u5730\u5740"),
    OPENAPI_ACCESS_DENIED(10602, "Access Denied"),
    OPENAPI_REQUEST_EXCEED(10603, "\u8d85\u51fa\u8bf7\u6c42\u6b21\u6570\u9650\u5236"),
    USER_BIND_MOBILE_FAILED(10700, "\u7ed1\u5b9a\u624b\u673a\u53f7\u5931\u8d25"),
    USER_BIND_MOBILE_EXISTS(10701, "\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u5176\u4ed6\u624b\u673a\u53f7"),
    USER_BIND_MOBILE_WITH_WEIXIN(10702, "\u8be5\u624b\u673a\u53f7\u5df2\u7ecf\u7ed1\u5b9a\u8fc7\u5176\u4ed6\u5fae\u4fe1\u8d26\u53f7"),
    INVALID_PARTNER_ID(10800, "\u65e0\u6548\u7684PartnerID"),
    PARTNER_ID_NOT_FOUND(10801, "PartnerID\u4e0d\u5b58\u5728"),
    SYSTEM_ERROR(20001, "\u7cfb\u7edf\u6267\u884c\u51fa\u9519"),
    BUSINESS_ERROR(20100, "\u4e1a\u52a1\u5904\u7406\u5f02\u5e38"),
    BIZ_NUM_ERROR(20101, "\u5546\u6237\u7f16\u53f7\u83b7\u53d6\u5931\u8d25"),
    FINISH_PRE_ASSIGNMENT(20102, "\u8bf7\u5148\u5b8c\u6210\u4e0a\u8282\u4efb\u52a1"),
    NOT_BUY_PERIOD(20103, "\u60a8\u672a\u8d2d\u4e70\u8be5\u8425\u671f"),
    REACH_UNLOCK_LIMIT(20104, "\u5468\u671f\u5185\u89e3\u9501\u7684\u4efb\u52a1\u5df2\u8fbe\u4e0a\u9650"),
    NOT_REACH_UNLOCK_DATE(20105, "\u672a\u5230\u6307\u5b9a\u7684\u89e3\u9501\u65e5\u671f"),
    OFFICIAL_ACCOUNT_NOT_FOUND(20200, "\u516c\u4f17\u53f7\u4e0d\u5b58\u5728"),
    BIZ_NOT_BINDING_OFFICIAL_ACCOUNT(20201, "\u5546\u6237\u672a\u6388\u6743\u516c\u4f17\u53f7"),
    BIZ_HAVA_AUTH_PLATFORM(20202, "\u5546\u6237\u5df2\u6388\u6743\u5230\u5f00\u653e\u5e73\u53f0,\u4e0d\u80fd\u518d\u8bbe\u7f6e\u4e3a\u5546\u6237\u6a21\u5f0f"),
    APPID_ALREADY_EXISTS(20203, "appId\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff5e"),
    MARKET_PLAN_STOP(20301, "\u6d3b\u52a8\u5df2\u7ecf\u7ed3\u675f\uff0c\u4e0b\u6b21\u65e9\u70b9\u6765\u54e6\uff5e"),
    MARKET_PLAN_TASK_FINISHED(20302, "\u60a8\u5df2\u7ecf\u53c2\u52a0\u8fc7\u6b64\u6d3b\u52a8\uff0c\u8bf7\u52ff\u91cd\u590d\u53c2\u52a0\u54e6\uff5e"),
    MARKET_PLAN_VIDEO_NOT_FINISHED(20303, "\u770b\u5b8c\u89c6\u9891\u624d\u80fd\u7b54\u9898\u54e6\uff5e"),
    MARKET_PLAN_QUESTION_IS_UPDATED(20304, "\u9898\u76ee\u5df2\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u7b54\u9898\uff5e"),
    MARKET_PLAN_ANSWER_NOT_FINISHED(20305, "\u4f5c\u7b54\u4e0d\u5b8c\u6574,\u8bf7\u91cd\u65b0\u63d0\u4ea4\uff5e"),
    MARKET_PLAN_CUSTOMER_AUDIT(20306, "\u60a8\u7684\u7533\u8bf7\u5df2\u63d0\u4ea4\u6b63\u5728\u5ba1\u6838\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\uff5e"),
    MARKET_PLAN_WAIT_START(20307, "\u6d3b\u52a8\u8fd8\u672a\u5f00\u59cb\u54e6~"),
    MARKET_PLAN_NO_PERMISSION(20308, "\u60a8\u6ca1\u6709\u6743\u9650\u53c2\u52a0\u6b64\u6d3b\u52a8"),
    MENU_NAME_DUPLICATE(20401, "\u5df2\u7ecf\u5b58\u5728\u8be5\u540d\u5b57\u7684\u83dc\u5355"),
    MENU_PARENT_NOT_EXISTS(20402, "\u7236\u83dc\u5355\u4e0d\u5b58\u5728"),
    MENU_PARENT_ERROR(20403, "\u4e0d\u80fd\u8bbe\u7f6e\u81ea\u5df1\u4e3a\u7236\u83dc\u5355"),
    MENU_NOT_EXISTS(20404, "\u83dc\u5355\u4e0d\u5b58\u5728"),
    MENU_EXISTS_CHILDREN(20405, "\u5b58\u5728\u5b50\u83dc\u5355\uff0c\u65e0\u6cd5\u5220\u9664"),
    MENU_PARENT_NOT_DIR_OR_MENU(20406, "\u7236\u83dc\u5355\u7684\u7c7b\u578b\u5fc5\u987b\u662f\u76ee\u5f55\u6216\u8005\u83dc\u5355"),
    SERVICE_ERROR(30001, "\u8c03\u7528\u7b2c\u4e09\u65b9\u670d\u52a1\u51fa\u9519"),
    NOTIFICATION_ERROR(30100, "\u901a\u77e5\u670d\u52a1\u51fa\u9519"),
    SMS_ERROR(30101, "\u77ed\u4fe1\u670d\u52a1\u51fa\u9519"),
    WEIXIN_ERROR(30200, "\u8c03\u7528\u5fae\u4fe1\u670d\u52a1\u5931\u8d25"),
    WEWORK_ERROR(30300, "\u8c03\u7528\u4f01\u5fae\u670d\u52a1\u5931\u8d25");

    private final Integer code;
    private final String msg;
    private static final Map<Integer, ResultCode> MAP;

    private ResultCode(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getMsg() {
        return this.msg;
    }

    public static ResultCode resultCodeOf(int code) {
        return MAP.getOrDefault(code, SYSTEM_ERROR);
    }

    static {
        MAP = Maps.newHashMap();
        for (ResultCode value : ResultCode.values()) {
            MAP.put(value.getCode(), value);
        }
    }
}

