/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.enums;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum LoginType {
    SYSTEM_PWD(1, "\u7cfb\u7edf\u7528\u6237\u540d\u548c\u5bc6\u7801"),
    SMS_CODE(2, "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u767b\u5f55"),
    OFFICIAL_SILENT(3, "\u5fae\u4fe1\u516c\u4f17\u53f7\u9759\u9ed8\u767b\u5f55");

    private final int type;
    private final String desc;
    private static final Map<Integer, LoginType> MAP;

    private LoginType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static LoginType getByType(int type) {
        return MAP.get(type);
    }

    public int getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        MAP = ImmutableMap.copyOf(Arrays.stream(LoginType.values()).collect(Collectors.toMap(LoginType::getType, e -> e)));
    }
}

