package com.baijiayun.duanxunbao.common.excel;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.WriteCellData;
import org.apache.commons.lang3.math.NumberUtils;

import java.util.List;

public class TrueOrFalseConvertor implements Converter<Integer> {

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public Class<?> supportJavaTypeKey() {
        return List.class;
    }


    @Override
    public WriteCellData<?> convertToExcelData(WriteConverterContext<Integer> context) {
        Integer val = context.getValue();
        String value;
        if (val == null || NumberUtils.INTEGER_ZERO.equals(val)) {
            value = "否";
        } else {
            value = "是";
        }
        WriteCellData<String> result = new WriteCellData<>();
        result.setStringValue(value);
        result.setType(CellDataTypeEnum.STRING);
        return result;
    }
}
