package com.baijiayun.duanxunbao.common.excel;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ReadConverterContext;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * desc: 将返回值中的List<String>专为字符串，逗号相连。
 *
 * @author yanmaoyuan
 * @date 2023/12/25
 */
public class SetConvertor implements Converter<Set<String>> {

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public Class<?> supportJavaTypeKey() {
        return List.class;
    }

    @Override
    public Set<String> convertToJavaData(ReadConverterContext<?> context) {
        String stringValue = context.getReadCellData().getStringValue();
        Set<String> result = Sets.newHashSet();
        result.addAll(Splitter.on(",").splitToList(stringValue));
        return result;
    }

    @Override
    public WriteCellData<?> convertToExcelData(WriteConverterContext<Set<String>> context) {
        Set<String> set = context.getValue();
        WriteCellData<String> result = new WriteCellData<>();
        if (CollectionUtils.isNotEmpty(set)) {
            set = set.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(set)) {
                result.setStringValue(Joiner.on(",").join(set));
            } else {
                result.setStringValue("");
            }
        } else {
            result.setStringValue("");
        }
        result.setType(CellDataTypeEnum.STRING);
        return result;
    }
}
