package com.baijiayun.duanxunbao.common.excel;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ReadConverterContext;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * desc: 将返回值中的List<String>专为字符串，逗号相连。
 *
 * @author yanmaoyuan
 * @date 2023/12/25
 */
public class ListConvertor implements Converter<List<String>> {

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public Class<?> supportJavaTypeKey() {
        return List.class;
    }

    @Override
    public List<String> convertToJavaData(ReadConverterContext<?> context) {
        String stringValue = context.getReadCellData().getStringValue();
        return Splitter.on(",").splitToList(stringValue);
    }

    @Override
    public WriteCellData<?> convertToExcelData(WriteConverterContext<List<String>> context) {
        List<String> list = context.getValue();
        WriteCellData<String> result = new WriteCellData<>();
        if (CollectionUtils.isNotEmpty(list)) {
            list = list.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(list)) {
                result.setStringValue(Joiner.on(",").join(list));
            } else {
                result.setStringValue("");
            }
        } else {
            result.setStringValue("");
        }
        result.setType(CellDataTypeEnum.STRING);
        return result;
    }
}
