package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author sunwen
 */

public enum WeworkRoleTypeEnum implements EnumService {
    NORMAL(1, "普通员工"),
    ADMIN(2, "超级管理员"),
    PERSON_IN_CHARGE(3, "负责人");

    private final int id;
    private final String desc;

    WeworkRoleTypeEnum(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, WeworkRoleTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>(3);
        for (WeworkRoleTypeEnum item : WeworkRoleTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static WeworkRoleTypeEnum get(int id) {
        return CACHE.get(id);
    }
}