package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum ShelfStatusEnum implements EnumService {
    DELETED(0,"已删除"),
    ON_SHELF(1,"已上架"),
    DOWN_SHELF(2,"已下架"),
    WAITING_SHELF(3,"等待上架")
    ;

    private final int value;
    private final String desc;

    ShelfStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, ShelfStatusEnum> CACHE;
    static {
        CACHE = new HashMap<>();
        for (ShelfStatusEnum item : ShelfStatusEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static ShelfStatusEnum get(int value) {
        return CACHE.get(value);
    }

    public static int getStatusByMode(int shellMode) {
        if(ShelfModeEnum.IMMEDIATELY.getValue() == shellMode){
            return ShelfStatusEnum.ON_SHELF.getValue();
        }else if(ShelfModeEnum.CLOCKING.getValue() == shellMode){
            return ShelfStatusEnum.WAITING_SHELF.getValue();
        }else if(ShelfModeEnum.NOT_YET.getValue() == shellMode){
            return ShelfStatusEnum.DELETED.getValue();
        }
        return ShelfStatusEnum.DELETED.getValue();
    }
}
