package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @Date: 2021/11/19 17:59
 * @Author: dayu
 */
public enum ReviewEnum implements EnumService {

    REVIEW_WAIT(0,"待审核"),
    REVIEW_PASS(1, "已通过"),
    REVIEW_REJECT(2, "已驳回");

    private int value;

    private String name;

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return null;
    }

    public String getName() {
        return name;
    }


    ReviewEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    private static final Map<Integer, ReviewEnum> cache;

    static {
        cache = new HashMap<>();
        for (ReviewEnum item : ReviewEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static ReviewEnum get(Integer value) {
        return cache.get(value);
    }
}
