package com.baijiayun.duanxunbao.common.enums;

import lombok.Getter;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2024/3/13
 */
@Getter
public enum ProgressState {

    READY("READY", "就绪"),

    ONGOING("ONGOING", "处理中"),

    STOP("STOP", "已停止"),

    FINISHED("FINISHED", "已完成");

    private final String value;

    private final String desc;

    ProgressState(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static ProgressState of(String value) {
        for (ProgressState state : values()) {
            if (state.getValue().equals(value)) {
                return state;
            }
        }
        return null;
    }
}
