package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum DevideClassTypeEnum implements EnumService {
    DONT(0,"不分班"),
    BY_COUNT(1,"自动分班"),
    BY_SALESMAN(2,"按销售分班")
    ;

    private final int value;
    private final String desc;

    DevideClassTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, DevideClassTypeEnum> CACHE;
    static {
        CACHE = new HashMap<>();
        for (DevideClassTypeEnum item : DevideClassTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static DevideClassTypeEnum get(int value) {
        return CACHE.get(value);
    }

    /**
     * 判断是否为分班类型
     **/
    public static boolean isDevideClass(int value) {
        return BY_COUNT.getValue() == value || BY_SALESMAN.getValue() == value;
    }
}
