package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 商户模式枚举类
 */
public enum BizModeEnum implements EnumService {

    NORMAL(0,"普通商户"),
    MAIN(1,"主商户"),
    SUB(2, "子商户")
    ;

    private final int value;
    private final String desc;

    BizModeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, BizModeEnum> CACHE;
    static {
        CACHE = new HashMap<>();
        for (BizModeEnum item : BizModeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static BizModeEnum get(int value) {
        return CACHE.get(value);
    }
}
