package com.baijiayun.duanxunbao.common.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
public enum AssignTypeEnum {
    LIVE("live","直播"),
    EXAM("exam","考试"),
    VIDEO("video","视频"),
    PRACTISE("practise","练习"),
    VIDEO_RED_PACKET("vrp","视频红包")
    ;

    private final String value;
    private final String desc;

    AssignTypeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private static final Map<String, AssignTypeEnum> CACHE;
    static {
        CACHE = new HashMap<>();
        for (AssignTypeEnum item : AssignTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static AssignTypeEnum get(String value) {
        return CACHE.get(value);
    }
}
