package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum ActivityRecordStatus implements EnumService{
    DEFAULT(0,"默认"),
    FAIL(1,"失败"),
    SUCCESS(2,"成功"),
    ACTIVITY_FAIL_BY_REFUND(3,"退款后拼团失败"),

    REFUND_FAIL_BY_ACTIVITY(4,"拼团失败后退款失败")

    ;

    private final int value;
    private final String desc;

    ActivityRecordStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, ActivityRecordStatus> CACHE;
    static {
        CACHE = new HashMap<>();
        for (ActivityRecordStatus item : ActivityRecordStatus.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static ActivityRecordStatus get(int value) {
        return CACHE.get(value);
    }
}
