package com.baijiayun.duanxunbao.common.dto.key;

import java.util.concurrent.TimeUnit;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2023/12/18
 */
public interface IRedisKey {

    String getKey();

    TimeUnit getTimeUnit();

    long getExpireTime();

    String getDesc();

    default String format(Object... args) {
        return String.format(getKey(), args);
    }

    default String prefixedKey(String prefix) {
        return prefix + getKey();
    }

    default String prefixedFormat(String prefix, Object... args) {
        return prefix + String.format(getKey(), args);
    }
}
