package com.baijiayun.duanxunbao.common.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2023/12/11
 */
@Data
public class TicketInfoDto implements Serializable {
    /**
     * 唯一编码，加密id
     */
    private String num;
    /**
     * 商户id
     */
    private Long bizId;
    /**
     * 商户num
     */
    private String bizNum;
    /**
     * 模块名称
     */
    private String moduleName;
    /**
     * 用户id
     */
    private Long userId;
    /**
     * 用户类型 1-customer 2-user
     * @see com.baijiayun.duanxunbao.common.enums.UserLoginType
     */
    private Integer userType;
    /**
     * 渠道ID
     */
    private Long channelId;
    /**
     * 企微成员ID
     */
    private String weworkUserId;
    /**
     * 客户num
     */
    private String customerNum;
    /**
     * 是否必须登录，主要用于APP端的登录流程控制。默认为0。
     */
    private Boolean isForceLogin;
    /**
     * 是否必须公众号显式授权，主要用于APP端的授权流程控制。默认为0。
     */
    private Boolean isForceUserInfo;
    /**
     * 备注
     */
    private String remark;
    /**
     * 欢迎语json对象
     */
    private String welcomeContent;
    /**
     * 新增的标签id，逗号分隔
     */
    private String tagIds;
    /**
     * 过期时间
     */
    private Date expireTime;
}
