package com.baijiayun.duanxunbao.common.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2024/3/13
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class TaskProgress implements Serializable {

    @ApiModelProperty("任务id")
    private String id;

    /**
     * 进度状态
     *
     * @see com.baijiayun.duanxunbao.common.enums.ProgressState
     */
    @ApiModelProperty("进度状态")
    private String state;

    /**
     * 总数量
     */
    @ApiModelProperty("总数量")
    private Long total;

    /**
     * 已经处理的数量
     */
    @ApiModelProperty("已经处理的数量")
    private Long current;

    /**
     * 进度百分比
     */
    @ApiModelProperty("进度百分比，0-100之间的整数")
    private Integer percentage;

    /**
     * 成功的数量
     */
    @ApiModelProperty("成功的数量")
    private Long success;

    /**
     * 失败的数量
     */
    @ApiModelProperty("失败的数量")
    private Long failed;

    /**
     * 错误文件地址
     */
    private String errorUrl;

    private String errorMsg;

    @JsonIgnore
    private String errorFileName;
    @JsonIgnore
    private String errorFileSize;

    /**
     * 任务执行耗时，单位: ms
     */
    @ApiModelProperty("任务开始时间戳，单位: ms")
    private Long timestamp;

    @ApiModelProperty("任务执行耗时，单位: ms")
    private Long costTime;
}
