package com.baijiayun.duanxunbao.common.exception;

import com.baijiayun.duanxunbao.common.dto.ResultError;
import com.baijiayun.duanxunbao.common.enums.ResultCode;

public class CustomException extends RuntimeException {

	private static final long serialVersionUID = -1L;
	private static final ResultError DEFAULT_ERROR_CODE = ResultCode.SYSTEM_ERROR;
	
	protected String message;
    protected ResultError errorCode;

    public CustomException() {
    }

	public CustomException(Throwable course) {
		super(course);
	}

	public final ResultError getErrorCode() {
		if(this.errorCode == null){
			return DEFAULT_ERROR_CODE;
		}
		return errorCode;
	}
	
	@Override
    public final String getMessage() {
    	if(this.message == null){
    		return this.getErrorCode().getMsg();
    	}
        return this.message;
    }
}
