package com.baijiayun.duanxunbao.common.enums;

import lombok.Getter;

@Getter
public enum WebSocketCmd {
    SIGN_IN_REQUEST(1, "登录请求"),
    SIGN_IN_RESPONSE(2, "登录响应"),
    SUBSCRIBE_REQUEST(3, "订阅微信消息请求"),
    SUBSCRIBE_RESPONSE(4, "订阅微信消息响应"),
    PING(5, "心跳消息"),
    PONG(6, "心跳回执"),
    WEWORK_MESSAGE(10, "企业微信消息"),// 营销宝上报企业微信消息
    FILE_DETAIL_MESSAGE(11, "文件详情消息"),// 用户在聊天界面异步获取文件详情，营销宝上报文件内容。
    ACK_MESSAGE(12, "回调消息"),// 调用营销宝接口，营销宝上报回调消息
    WEWORK_ONLINE_STATUS(13, "营销宝上下线消息"),
    NOTICE_MSG(14, "系统通知消息");

    private final int cmd;

    private final String desc;

    WebSocketCmd(int cmd, String desc) {
        this.cmd = cmd;
        this.desc = desc;
    }
}