package com.baijiayun.duanxunbao.common.enums;

import com.baijiayun.duanxunbao.common.dto.ResultError;

/**
 * 错误码
 * 五位组成 1 0000
 * 100 以内为通用错误码
 * 1-用户端错误
 * 2-当前系统异常
 * 3-第三方服务异常
 * 大的错误类间的步长间距预留100
 */
public enum ResultCode implements ResultError {

    SUCCESS(200, "成功"),

    USER_ERROR(10001, "用户请求服务异常"),
    USER_SIGN_ERROR(10002, "签名校验失败"),
    USER_DOMAIN_NOT_FOUND(10003, "用户域名不存在"),
    USER_LOGIN_FAILED(10100, "用户登录失败"),
    USER_INVALID_PASSWORD(10101, "账号或密码错误"),
    USER_INVALID_CAPTCHA(10102, "验证码错误"),
    USER_LOGIN_EXPIRED(10103, "登录超时"),
    USER_PASSWORD_NOT_SET(10104, "账号未修改过密码，请先修改密码再登录"),
    USER_ACCOUNT_OVER_LIMIT(10105, "登录失败，账号超过限制"),
    USER_NO_AUTH(10200, "您没有权限进行该操作"),
    USER_AUTH_EXPIRED(10201, "授权已过期"),
    USER_NOT_LOGIN(10202, "用户未登录"),
    USER_TOKEN_EXPIRE(10203, "用户token过期"),
    USER_TOKEN_INVALID(10204, "用户token无效"),
    USER_DISABLED(10205, "账号已禁用"),
    USER_PARAM_ERROR(10300, "用户请求参数错误"),
    USER_PARAM_REQUIRED(10301, "缺少必要的请求参数"),

    USER_REGISTER_FAILED(10400, "用户注册失败"),
    USER_REGISTERED(10410, "用户已注册"),
    USER_MOBILE_REGISTERED(10411, "用户手机号已注册"),

    SYSTEM_ERROR(20001, "系统执行出错"),

    BUSINESS_ERROR(20100, "业务处理异常"),
    BIZ_NUM_ERROR(20101, "商户编号获取失败"),

    OFFICIAL_ACCOUNT_NOT_FOUND(20200, "公众号不存在"),
    BIZ_NOT_BINDING_OFFICIAL_ACCOUNT(20201, "商户未授权公众号"),

    SERVICE_ERROR(30001, "调用第三方服务出错"),
    NOTIFICATION_ERROR(30100, "通知服务出错"),
    SMS_ERROR(30101, "短信服务出错")
    ;

    private final Integer code;
    private final String msg;

    ResultCode(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    @Override
    public Integer getCode() {
        return code;
    }

    @Override
    public String getMsg() {
        return msg;
    }

    public static ResultCode resultCodeOf(int code){
        for(ResultCode rc : values()){
            if(rc.code == code){
                return rc;
            }
        }
        return SYSTEM_ERROR;
    }
}