/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @title BizChannel
 * @author yanmaoyuan
 * @date 2021年4月25日
 * @version 1.0
 */
public enum BizChannel implements EnumService {
    HOME_PAGE(1, "主页扫码安装"),
    APP_STORE(2, "企业微信应用市场");

    private final int id;
    private final String desc;

    private BizChannel(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, BizChannel> cache;

    static {
        cache = new HashMap<>(3);
        for (BizChannel item : BizChannel.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static BizChannel get(int status) {
        return cache.get(status);
    }
}