package com.baijiayun.duanxunbao.common.enums;


import java.util.HashMap;
import java.util.Map;

public enum AddFriendReplyModuleEnum implements EnumService{
    AD(1, "AD"),

    WEWORK_ACQUISITION(2,"weworkAcquisition")
    ;

    private final int id;
    private final String desc;

    AddFriendReplyModuleEnum(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<String, AddFriendReplyModuleEnum> cache;

    static {
        cache = new HashMap<>();
        for (AddFriendReplyModuleEnum item : AddFriendReplyModuleEnum.values()) {
            cache.put(item.getDesc(), item);
        }
    }

    public static AddFriendReplyModuleEnum get(String desc) {
        return cache.get(desc);
    }
}
