package com.baijiayun.duanxunbao.common.dto;

import com.baijiayun.duanxunbao.common.enums.ResultCode;
import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2023/10/23
 */
@Data
public class Result<T> implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 返回处理消息
     */
    private String msg = "";

    /**
     * 返回代码
     */
    private Integer code = 0;

    /**
     * 返回数据对象 data
     */
    private T data;

    private PageDto pageDto;

    public Result() {
    }

    /**
     * 兼容VUE3版token失效不跳转登录页面
     * @param code
     * @param msg
     */
    public Result(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Result<T> success(String message) {
        this.msg = message;
        this.code = ResultCode.SUCCESS.getCode();
        return this;
    }

    public boolean isSuccess() {
        return ResultCode.SUCCESS.getCode().equals(this.code);
    }

    public boolean isDataValid() {
        return isSuccess() && Objects.nonNull(data);
    }

    public Result<T> code(Integer code) {
        this.code = code;
        return this;
    }

    public Result<T> msg(String message) {
        this.msg = message;
        return this;
    }

    public Result<T> data(T data) {
        this.data = data;
        return this;
    }

    public Result<T> pageDto(PageDto pageDto) {
        this.pageDto = pageDto;
        return this;
    }

    public static <T> Result<T> ok() {
        Result<T> r = new Result<>();
        r.setCode(ResultCode.SUCCESS.getCode());
        return r;
    }

    public static <T> Result<T> ok(String msg) {
        Result<T> r = new Result<>();
        r.setCode(ResultCode.SUCCESS.getCode());
        r.setData((T) msg);
        r.setMsg(msg);
        return r;
    }

    public static Result<Boolean> ok(Boolean data) {
        Result<Boolean> r = new Result<>();
        r.setCode(ResultCode.SUCCESS.getCode());
        r.setData(data);
        return r;
    }

    public static <T> Result<T> ok(T data) {
        Result<T> r = new Result<>();
        r.setCode(ResultCode.SUCCESS.getCode());
        r.setData(data);
        return r;
    }

    public static <T> Result<T> ok(T data, PageDto pageDto) {
        Result<T> r = new Result<>();
        r.setCode(ResultCode.SUCCESS.getCode());
        r.setData(data);
        r.setPageDto(pageDto);
        return r;
    }

    public static <T> Result<T> ok(String msg, T data) {
        Result<T> r = new Result<>();
        r.setCode(ResultCode.SUCCESS.getCode());
        r.setData(data);
        r.setMsg(msg);
        return r;
    }

    public static <T> Result<T> error() {
        return error(ResultCode.SYSTEM_ERROR);
    }

    public static <T> Result<T> error(String msg, T data) {
        Result<T> r = new Result<>();
        r.setCode(ResultCode.SYSTEM_ERROR.getCode());
        r.setMsg(msg);
        r.setData(data);
        return r;
    }

    public static <T> Result<T> error(String msg) {
        return error(ResultCode.SYSTEM_ERROR.getCode(), msg);
    }

    public static <T> Result<T> error(int code, String msg) {
        Result<T> r = new Result<>();
        r.setCode(code);
        r.setMsg(msg);
        return r;
    }

    public static <T> Result<T> error(ResultError error) {
        return error(error.getCode(), error.getMsg());
    }

    public static <T> Result<T> error(Result<?> result) {
        return error(result.getCode(), result.getMsg());
    }

    /**
     * 无权限访问返回结果
     */
    public static <T> Result<T> noAuth() {
        return error(ResultCode.USER_NO_AUTH);
    }

    /**
     * 无权限访问返回结果
     */
    public static <T> Result<T> noAuth(String msg) {
        return error(ResultCode.USER_NO_AUTH.getCode(), msg);
    }

}
