package com.baijiayun.duanxunbao.common.dto;

import io.swagger.annotations.ApiModel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

@ToString
@EqualsAndHashCode
@ApiModel(description = "分页参数")
public class PageDto implements Serializable {
	private static final long serialVersionUID = 9103057732548944201L;
	private static final int DEF_PAGE_SIZE = 20;
	private static final int DEF_PAGE_NUM = 1;

	private static final PageDto DEF_PAGE_DTO = new PageDto();

	public static PageDto getDefPageDto() {
		try {
			return (PageDto) DEF_PAGE_DTO.clone();
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}

	@Getter
	private Integer count;

	@Getter
	private Integer curPageCount;
	private Integer pageNum;
	private Integer pageSize;

	@Getter
	@Setter
	private boolean needCount = true;

	public PageDto() {
		this.count = 0;
		this.pageNum = DEF_PAGE_NUM;
		this.pageSize = DEF_PAGE_SIZE;
	}

	public void setCount(Integer count) {
		if (count == null) {
			count = 0;
		}
		this.count = count;
	}

	public void setCurPageCount(Integer curPageCount) {
		if (curPageCount == null) {
			curPageCount = 0;
		}
		this.curPageCount = curPageCount;
	}

	public Integer getPageNum() {
		if (pageNum == null || pageNum <= 0) {
			pageNum = DEF_PAGE_NUM;
		}
		return pageNum;
	}

	public Integer getTotalPageNum() {
		if (count == 0) {
			return 0;
		}
		return (int) Math.ceil(count / pageSize.doubleValue());
	}

	public void setPageNum(Integer pageNum) {
		if (pageNum == null || pageNum <= 0) {
			pageNum = DEF_PAGE_NUM;
		}
		this.pageNum = pageNum;
	}

	public void increasePageNum() {
		this.pageNum++;
	}

	public Integer getPageSize() {
		if (pageSize == null || pageSize <= 0) {
			pageSize = DEF_PAGE_SIZE;
		}
		return pageSize;
	}

	public void setPageSize(Integer pageSize) {
		if (pageSize == null || pageSize <= 0) {
			pageSize = DEF_PAGE_SIZE;
		}
		this.pageSize = pageSize;
	}

	public void validate() {
		int num = getPageNum();
		int size = getPageSize();
		int cnt = getCount();
		// 无数据特殊处理
		if (cnt <= 0) {
			setPageNum(1);
			return;
		}
		// 当申请的页数大于总页数时，返回最后一页数据
		int lastPageNum = (cnt - 1) / size + 1;
		if (lastPageNum > num) {
			setCurPageCount(size);
			return;
		}
		int lastPageSize = (cnt - 1) % size + 1;
		setCurPageCount(lastPageSize);
		if (lastPageNum < num) {
			setPageNum(lastPageNum);
		}
	}

	public int firstNum() {
		int num = getPageNum();
		int size = getPageSize();
		return (num - 1) * size;
	}

	public int getOffset() {
		return firstNum();
	}

}
